﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>


param
(
    [string]
    $VersionXmlPath,

    [string]
    $Identifier,

    [string]
    $HeaderPath
)

trap
{
    Write-Error -ErrorRecord $_
    exit 1
}

Set-StrictMode -Version Latest

$xml = [xml] (Get-Content $VersionXmlPath)

if($Identifier -eq "SDK")
{

    $major = $xml.Product.Version.Major
    $minor = $xml.Product.Version.Minor
    $micro = $xml.Product.Version.Micro
    $relstep = $xml.Product.Version.Relstep

    $headerContent = @"
/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#define NN_$($Identifier)_VERSION_MAJOR          $($major)
#define NN_$($Identifier)_VERSION_MINOR          $($minor)
#define NN_$($Identifier)_VERSION_MICRO          $($micro)
#define NN_$($Identifier)_VERSION_RELSTEP        $($relstep)

#ifndef NN_$($Identifier)_VERSION_NUMBER
#define NN_$($Identifier)_VERSION_NUMBER(major, minor, micro, relstep) \
    (((major) << 24) | ((minor) << 16)  | ((micro) << 8) | (relstep << 0))

#define NN_$($Identifier)_CURRENT_VERSION_NUMBER \
    NN_$($Identifier)_VERSION_NUMBER(NN_$($Identifier)_VERSION_MAJOR, NN_$($Identifier)_VERSION_MINOR, NN_$($Identifier)_VERSION_MICRO, NN_$($Identifier)_VERSION_RELSTEP)
#endif
"@
}
elseif($Identifier -eq "NX_ADDON")
{

    $major = $xml.Product.Version.Major
    $minor = $xml.Product.Version.Minor
    $micro = $xml.Product.Version.Micro
    $relstep = $xml.Product.Version.Relstep

    $headerContent = @"
/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#define NN_$($Identifier)_VERSION_MAJOR          $($major)
#define NN_$($Identifier)_VERSION_MINOR          $($minor)
#define NN_$($Identifier)_VERSION_MICRO          $($micro)
#define NN_$($Identifier)_VERSION_RELSTEP        $($relstep)

#ifndef NN_$($Identifier)_VERSION_NUMBER
#define NN_$($Identifier)_VERSION_NUMBER(major, minor, micro, relstep) \
    (((major) << 24) | ((minor) << 16)  | ((micro) << 8) | (relstep << 0))

#define NN_$($Identifier)_CURRENT_VERSION_NUMBER \
    NN_$($Identifier)_VERSION_NUMBER(NN_$($Identifier)_VERSION_MAJOR, NN_$($Identifier)_VERSION_MINOR, NN_$($Identifier)_VERSION_MICRO, NN_$($Identifier)_VERSION_RELSTEP)
#endif
"@
}
elseif($Identifier -eq "FIRMWARE")
{
    $major = $xml.Product.Version.Major
    $minor = $xml.Product.Version.Minor
    $micro = $xml.Product.Version.Micro
    $majorRelstep = $xml.Product.Version.MajorRelstep
    $minorRelstep = $xml.Product.Version.MinorRelstep
    $digest = $xml.Product.Version.Digest

    $headerContent = @"
/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#define NN_$($Identifier)_VERSION_MAJOR          $($major)
#define NN_$($Identifier)_VERSION_MINOR          $($minor)
#define NN_$($Identifier)_VERSION_MICRO          $($micro)
#define NN_$($Identifier)_VERSION_MAJORRELSTEP   $($majorRelstep)
#define NN_$($Identifier)_VERSION_MINORRELSTEP   $($minorRelstep)
#define NN_$($Identifier)_VERSION_DIGEST         "$($digest)"

#ifndef NN_$($Identifier)_VERSION_NUMBER
#define NN_$($Identifier)_VERSION_NUMBER(major, minor, micro, majorRelstep) \
    (((major) << 24) | ((minor) << 16)  | ((micro) << 8) | ((majorRelstep) << 0))

#define NN_$($Identifier)_CURRENT_VERSION_NUMBER \
    NN_$($Identifier)_VERSION_NUMBER(NN_$($Identifier)_VERSION_MAJOR, NN_$($Identifier)_VERSION_MINOR, NN_$($Identifier)_VERSION_MICRO, NN_$($Identifier)_VERSION_MAJORRELSTEP)
#endif
"@
}
$headerContent | Set-Content $HeaderPath -Encoding UTF8
