﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/*!
    @file
    @brief 全てのライブラリで共通して使用する C 言語用のマクロの定義
*/

#include <nn/TargetConfigs/build_Compiler.h>

#if defined(NN_BUILD_CONFIG_COMPILER_VC)
    #include <nnc/detail/nn_Macro-compiler.vc.h>
#elif defined(NN_BUILD_CONFIG_COMPILER_GCC)
    #include <nnc/detail/nn_Macro-compiler.gcc.h>
#elif defined(NN_BUILD_CONFIG_COMPILER_CLANG)
    #include <nnc/detail/nn_Macro-compiler.clang.h>
#elif defined(NN_BUILD_CONFIG_COMPILER_GHS)
    #include <nnc/detail/nn_Macro-compiler.ghs.h>
#else
    #error  "未サポートのコンパイラー種別が指定されています。"
#endif

// Warning が出るため C言語版では未対応
//#define NNC_PADDING2 NNC_PADDING1; NNC_PADDING1

// Warning が出るため C言語版では未対応
//#define NNC_PADDING3 NNC_PADDING1; NNC_PADDING2

// Warning が出るため C言語版では未対応
//#define NNC_PADDING4 NNC_PADDING1; NNC_PADDING3

// Warning が出るため C言語版では未対応
//#define NNC_PADDING5 NNC_PADDING1; NNC_PADDING4

// Warning が出るため C言語版では未対応
//#define NNC_PADDING6 NNC_PADDING1; NNC_PADDING5

// Warning が出るため C言語版では未対応
//#define NNC_PADDING7 NNC_PADDING1; NNC_PADDING6

// Warning が出るため C言語版では未対応
//#define NNC_PADDING8 NNC_PADDING1; NNC_PADDING7

#if defined(NN_BUILD_FOR_DOCUMENT_GENERATION)

//----------------------------------------------------------------------------
//  Doxygen ドキュメント
//----------------------------------------------------------------------------

//! @{
//! @name 言語サポート

/*!
    @brief アライメントのバイトサイズを指定します。

    @param[in]  alignment アライメントのバイトサイズ（2のべき乗）
    @details    使用例：
                @code
                struct NNC_ALIGNAS( 16 ) Example1
                {
                    int x;
                };

                struct Example2
                {
                    NNC_ALIGNAS( 16 ) char buffer[ 64 ];
                };

                NNC_ALIGNAS( 16 ) char buffer[ 256 ];
                @endcode
*/
#define NNC_ALIGNAS( alignment )

/*!
    @brief アライメントのバイトサイズを取得します。

    @param[in]  type 対象の型
    @return     アライメントのバイトサイズ
*/
#define NNC_ALIGNOF( type )

/*!
    @brief 決して返らない関数に対するコンパイラ警告を抑制します。

    @details    使用例：
                @code
                NNC_NORETURN
                void DoSomething()
                {
                    NNC_ABORT( "error" );
                }
                @endcode
*/
#define NNC_NORETURN

// C++ 専用機能
//#define NNC_NOEXCEPT

// C++ 専用機能
//#define NNC_OVERRIDE

// C++ 専用機能
//#define NNC_EXPLICIT_OPERATOR

/*!
    @brief インライン化を意図していないことを明示します。

    @details    使用例：
                @code
                NNC_NOINLINE
                void DoSomething()
                {
                }
                @endcode
*/
#define NNC_NOINLINE

/*!
    @brief インライン化を強制する意図を明示します。

    @details    使用例：
                @code
                NNC_FORCEINLINE
                void DoSomething()
                {
                }
                @endcode
*/
#define NNC_FORCEINLINE

/*!
    @brief インラインする意図を明示します。

    @details    使用例：
                @code
                NNC_INLINE
                void DoSomething()
                {
                }
                @endcode
*/
#define NNC_INLINE

/*!
    @brief 現在の関数の名前です。

    @details    関数名の書式は、処理系に依存します。
*/
#define NNC_CURRENT_FUNCTION_NAME

//! @}

//----------------------------------------------------------------------------

//! @{
//! @name 環境毎の問題回避

// C++ 専用機能
//#define NNC_DEFINE_STATIC_CONSTANT( definition )

/*!
    @brief 外部の関数型マクロによるシンボル置き換えを抑止します。

    @details    使用例：
                @code
                std::numeric_limits< float >::min NNC_PREVENT_MACRO_FUNC ( x, y );
                @endcode
*/
#define NNC_PREVENT_MACRO_FUNC

//! @}

//----------------------------------------------------------------------------

//! @{
//! @name ユーティリティ

// C++ 専用機能
//#define NNC_DISALLOW_COPY( type )

// C++ 専用機能
//#define NNC_DISALLOW_MOVE( type )

/*!
    @brief 型または変数のビットサイズを取得します。

    @param[in]  type 対象の型または変数
    @return     型または変数のビットサイズ
*/
#define NNC_BITSIZEOF( type )

/*!
    @brief 文字列リテラルを作成します。

    @param[in]  text 文字列化するシンボル
    @return     文字列リテラル
*/
#define NNC_MACRO_STRINGIZE( text )

/*!
    @brief シンボルを連結します。

    @param[in]    x 前から連結するシンボル
    @param[in]    y 後ろから連結するシンボル
    @return       連結されたシンボル
*/
#define NNC_MACRO_CONCATENATE( x, y )

/*!
    @brief 重複しない一時シンボルを作成します。

    @param[in]  prefix 接頭辞
    @return     一時シンボル
*/
#define NNC_MAKE_TEMPORARY_NAME( prefix )

// C言語版では未対応
//#define NNC_FALL_THROUGH

/*!
    @brief switch 文において、default ラベルに決して到達しないことを表明します。
           default ラベルに到達した場合、実行を停止します。
*/
#define NNC_UNEXPECTED_DEFAULT

/*!
    @brief クラス内部に暗黙にパディングが挿入されたことの警告を有効にします。
*/
#define NNC_ENABLE_WARNING_IMPLICIT_PADDING_WITHIN_CLASS

/*!
    @brief クラス内部に、1 バイトのサイズを持つ無名のメンバを定義します。このメンバは、1 バイトアラインです。
*/
#define NNC_PADDING1

//! @}

//----------------------------------------------------------------------------

//! @{
//! @name 警告対策

// C++ 専用機能
//#define NNC_IMPLICIT

/*!
    @brief 意図した未使用変数に対するコンパイラ警告を抑制します。

    @param[in]  variable 対象の変数
*/
#define NNC_UNUSED( variable )

/*!
    @brief 意図した定数分岐を明示してコンパイラ警告を抑制します。

    @param[in]  condition 条件式
    @return     入力した条件式
*/
#define NNC_STATIC_CONDITION( condition )

/*!
    @brief コンパイラの警告レベルを退避します。

    @details NNC_PRAGMA_POP_WARNINGS と対で使用します。
*/
#define NNC_PRAGMA_PUSH_WARNINGS

/*!
    @brief コンパイラの警告レベルを復帰します。

    @details NNC_PRAGMA_PUSH_WARNINGS と対で使用します。
*/
#define NNC_PRAGMA_POP_WARNINGS

/*!
    @brief 定数のオーバーフローに対するコンパイラの警告を無効化します。

    @details NNC_PRAGMA_PUSH_WARNINGS と NNC_PRAGMA_POP_WARNINGS の間で使用します。
*/
#define NNC_DISABLE_WARNING_OVERFLOW

/*!
    @brief 関数内で宣言された静的変数に対するコンパイラの警告を無効化します。

    @details NNC_PRAGMA_PUSH_WARNINGS と NNC_PRAGMA_POP_WARNINGS の間で使用します。
*/
#define NNC_DISABLE_WARNING_LOCAL_STATIC

/*!
    @brief 未使用変数に対するコンパイラの警告を無効化します。

    @details NNC_PRAGMA_PUSH_WARNINGS と NNC_PRAGMA_POP_WARNINGS の間で使用します。
*/
#define NNC_DISABLE_WARNING_UNUSED_VAR

//! @}

#endif  /* NN_BUILD_FOR_DOCUMENT_GENERATION */

