﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Supported content type flags.
 */

#pragma once

#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace edid {

    /**
     * @brief Content types supported by displays.
     */
    struct ContentType
    {
        typedef nn::util::BitFlagSet<4, ContentType>::Flag<0> Graphics; //!< Graphics content type.
        typedef nn::util::BitFlagSet<4, ContentType>::Flag<1> Photo;    //!< Photo content type.
        typedef nn::util::BitFlagSet<4, ContentType>::Flag<2> Cinema;   //!< Cinema content type.
        typedef nn::util::BitFlagSet<4, ContentType>::Flag<3> Game;     //!< Game content type.
    };

    /**
     * @brief Set of content types that may be supported by displays.
     */
    typedef nn::util::BitFlagSet<4, ContentType> ContentTypeSet;

}}
