﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Defines for blank levels.
 */

#pragma once

namespace nn { namespace edid {

    /**
     * @brief Blank levels supported by the display.
     *
     * @details Blank levels are only really defined for analog signals.
     */
    enum BlankLevel
    {
        BlankLevel_Digital, //!< The display uses a digital signal.
        BlankLevel_Equal,   //!< Blank level is equal to black level.
        BlankLevel_Setup,   //!< Blank-to-black setup or pedestal.
    };

}}
