﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      diag モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_DIAG_TRACE(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(diag, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_DIAG_TRACE_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(diag, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_DIAG_TRACE_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(diag, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_DIAG_TRACE_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(diag, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_DIAG_INFO(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(diag, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_DIAG_INFO_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(diag, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_DIAG_INFO_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(diag, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_DIAG_INFO_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(diag, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_DIAG_WARN(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(diag, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_DIAG_WARN_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(diag, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_DIAG_WARN_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(diag, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_DIAG_WARN_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(diag, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_DIAG_ERROR(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(diag, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_DIAG_ERROR_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(diag, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_DIAG_ERROR_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(diag, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_DIAG_ERROR_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(diag, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_DIAG_FATAL(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(diag, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_DIAG_FATAL_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(diag, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_DIAG_FATAL_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(diag, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_DIAG_FATAL_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(diag, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_DIAG_VTRACE(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(diag, Trace, 0, format, args)
#define NN_DETAIL_DIAG_VTRACE_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(diag, Trace, 1, format, args)
#define NN_DETAIL_DIAG_VTRACE_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(diag, Trace, 2, format, args)
#define NN_DETAIL_DIAG_VTRACE_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(diag, Trace, 3, format, args)

#define NN_DETAIL_DIAG_VINFO(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(diag, Info, 0, format, args)
#define NN_DETAIL_DIAG_VINFO_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(diag, Info, 1, format, args)
#define NN_DETAIL_DIAG_VINFO_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(diag, Info, 2, format, args)
#define NN_DETAIL_DIAG_VINFO_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(diag, Info, 3, format, args)

#define NN_DETAIL_DIAG_VWARN(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(diag, Warn, 0, format, args)
#define NN_DETAIL_DIAG_VWARN_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(diag, Warn, 1, format, args)
#define NN_DETAIL_DIAG_VWARN_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(diag, Warn, 2, format, args)
#define NN_DETAIL_DIAG_VWARN_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(diag, Warn, 3, format, args)

#define NN_DETAIL_DIAG_VERROR(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(diag, Error, 0, format, args)
#define NN_DETAIL_DIAG_VERROR_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(diag, Error, 1, format, args)
#define NN_DETAIL_DIAG_VERROR_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(diag, Error, 2, format, args)
#define NN_DETAIL_DIAG_VERROR_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(diag, Error, 3, format, args)

#define NN_DETAIL_DIAG_VFATAL(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(diag, Fatal, 0, format, args)
#define NN_DETAIL_DIAG_VFATAL_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(diag, Fatal, 1, format, args)
#define NN_DETAIL_DIAG_VFATAL_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(diag, Fatal, 2, format, args)
#define NN_DETAIL_DIAG_VFATAL_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(diag, Fatal, 3, format, args)

#define NN_DETAIL_DIAG_PUT_TRACE(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(diag, Trace, 0, text, length)
#define NN_DETAIL_DIAG_PUT_TRACE_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(diag, Trace, 1, text, length)
#define NN_DETAIL_DIAG_PUT_TRACE_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(diag, Trace, 2, text, length)
#define NN_DETAIL_DIAG_PUT_TRACE_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(diag, Trace, 3, text, length)

#define NN_DETAIL_DIAG_PUT_INFO(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(diag, Info, 0, text, length)
#define NN_DETAIL_DIAG_PUT_INFO_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(diag, Info, 1, text, length)
#define NN_DETAIL_DIAG_PUT_INFO_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(diag, Info, 2, text, length)
#define NN_DETAIL_DIAG_PUT_INFO_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(diag, Info, 3, text, length)

#define NN_DETAIL_DIAG_PUT_WARN(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(diag, Warn, 0, text, length)
#define NN_DETAIL_DIAG_PUT_WARN_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(diag, Warn, 1, text, length)
#define NN_DETAIL_DIAG_PUT_WARN_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(diag, Warn, 2, text, length)
#define NN_DETAIL_DIAG_PUT_WARN_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(diag, Warn, 3, text, length)

#define NN_DETAIL_DIAG_PUT_ERROR(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(diag, Error, 0, text, length)
#define NN_DETAIL_DIAG_PUT_ERROR_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(diag, Error, 1, text, length)
#define NN_DETAIL_DIAG_PUT_ERROR_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(diag, Error, 2, text, length)
#define NN_DETAIL_DIAG_PUT_ERROR_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(diag, Error, 3, text, length)

#define NN_DETAIL_DIAG_PUT_FATAL(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(diag, Fatal, 0, text, length)
#define NN_DETAIL_DIAG_PUT_FATAL_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(diag, Fatal, 1, text, length)
#define NN_DETAIL_DIAG_PUT_FATAL_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(diag, Fatal, 2, text, length)
#define NN_DETAIL_DIAG_PUT_FATAL_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(diag, Fatal, 3, text, length)
