﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;
using ZarfServerAccessor;

namespace ZarfUploader
{
    class Program
    {
        static void PerformProcess(ZarfUploaderParam param)
        {
            var setting = ServerSetting.Deserialize(param.SettingFile);
            var uploader = new Uploader(setting);

            uploader.LoadFamilyTree();

            if (param.TargetZarfFiles.Count() > 0)
            {
                uploader.Upload(param.TargetZarfFiles);
            }

            if (param.CoreReleaseZarf != null)
            {
                uploader.SetCoreReleaseZarf(param.CoreRelease, param.CoreReleaseZarf);
            }

            if (param.TargetZarfFiles.Count() > 0 && param.StockControlMode)
            {
                uploader.StockControl(param.TargetZarfFiles, param.SnapshotRegex, param.MaxSnapshotCount);
            }
        }

        static void Main(string[] args)
        {
            ZarfUploaderParam param;

            try
            {
                if(!CommandLineParser.Default.ParseArgs(args, out param))
                {
                    return;
                }
            }
            catch
            {
                Environment.ExitCode = 1;
                return;
            }

            try
            {
                PerformProcess(param);
            }
            catch (Exception e)
            {
                Environment.ExitCode = 1;
                Console.WriteLine(e.StackTrace);
                Console.WriteLine(e.Message);
                return;
            }
            return;
        }
    }
}
