﻿using Newtonsoft.Json;
using Newtonsoft.Json.Serialization;
using Nintendo.Zarf;
using System;
using System.Collections.Generic;
using System.Globalization;
using System.IO;
using System.IO.Compression;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using ZarfCreator.MetaData;
using ZarfCreator.Parser;

namespace ZarfCreator
{
    public class ZarfCreator
    {
        private ZarfCreatorParam Param;

        /// <summary>
        /// ZarfCreator クラスのインスタンスを作成します。
        /// </summary>
        /// <param name="param">コマンドライン引数</param>
        public ZarfCreator(ZarfCreatorParam param)
        {
            this.Param = param;
        }

        /// <summary>
        /// Zarf の作成を行います。
        /// </summary>
        public void Create()
        {
            var zarfParser = new ZarfDefinitionParser(this.Param.SdkRoot, this.Param.ContentsLocale, this.Param.SnapShotVersion);

            var zarfInfo = zarfParser.ReadRecursively(this.Param.SourceZarfDefinitionPath, this.Param.SourceArchivePaths);

            var builder = new ZarfBuilder(zarfInfo, this.Param.SdkRoot, this.Param.SourceArchivePaths);

            builder.Create(this.Param.OutputPath);

            Console.Out.WriteLine("Create the zarf '{0}.zarf' (from : {1})", zarfInfo.Name, this.Param.SourceZarfDefinitionPath);
        }
    }
}
