﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ZarfCreator.VersionData
{
    public class SnapshotVersionDataFactory
    {
        /// <summary>
        /// スナップショット情報を付加したバージョン文字列を作成します。
        /// </summary>
        /// <param name="version">もとになるバージョン文字列</param>
        /// <param name="snapshot">スナップショット文字列</param>
        /// <param name="usePrerelease">スナップショット文字列をプレリリースに付加する場合はtrue。
        /// メタデータに付加する場合は false。</param>
        /// <returns></returns>
        public static string CreateSnapshotVersion(string version, string snapshot, bool usePrerelease)
        {
            var sep = usePrerelease ? "-" : "+";
            var metaIdx = version.IndexOf('+');
            var sepIdx = -1;
            if (sep == "+")
            {
                sepIdx = version.Length;
                sep = metaIdx != -1 ? "." : sep;
            }
            else
            {
                sepIdx = metaIdx == -1 ? version.Length : metaIdx;
                var preIdx = version.IndexOf('-', 0, sepIdx);
                sep = preIdx != -1 ? "." : sep;
            }

            return
                version.Substring(0, sepIdx)
                + sep
                + snapshot
                + version.Substring(sepIdx);
        }
    }
}
