﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using YamlDotNet.RepresentationModel;

namespace ZarfCreator.Parser
{
    public class YamlDataReader
    {
        public static Dictionary<string, object> Read(string path)
        {
            try
            {
                using (var reader = new StreamReader(path))
                {
                    YamlStream yaml = new YamlStream();
                    yaml.Load(reader);

                    var mapping = (YamlMappingNode)yaml.Documents[0].RootNode;
                    return (Dictionary<string, object>)ReadNodes(mapping);
                }
            }
            catch (IOException ex)
            {
                Console.Error.WriteLine("ERROR: Failed to open the YAML file.");
                Console.Error.WriteLine(ex.Message);
                throw;
            }
            catch (Exception ex)
            {
                Console.Error.WriteLine("ERROR: Invalid YAML format.");
                Console.Error.WriteLine(ex.Message);
                throw;
            }
        }

        private static object ReadNodes(YamlNode node)
        {
            if (node is YamlScalarNode)
            {
                return (node as YamlScalarNode).Value;
            }

            if (node is YamlSequenceNode)
            {
                List<object> result = new List<object>();
                foreach (YamlNode child in (node as YamlSequenceNode).Children)
                {
                    result.Add(ReadNodes(child));
                }
                return result;
            }

            if (node is YamlMappingNode)
            {
                Dictionary<string, object> result = new Dictionary<string, object>();
                foreach (var child in (node as YamlMappingNode).Children)
                {
                    result.Add((child.Key as YamlScalarNode).Value, ReadNodes(child.Value));
                }
                return result;
            }

            throw new YamlDotNet.Core.SyntaxErrorException("ERROR: Failed to parse the YAML file.");
        }
    }
}
