﻿using System;
using System.Collections.Generic;
using ZarfCreator.ZarfDefinitionData;

namespace ZarfCreator.Parser
{
    internal class RollbackParser
    {
        public RollbackParser()
        {
        }

        internal RollbackInfo Parse(Dictionary<string, object> source)
        {
            var rollback = new RollbackInfo();

            foreach (var pair in source)
            {
                try
                {
                    switch (pair.Key)
                    {
                    case RollbackElement.TrackFiles:
                        if (pair.Value as string != string.Empty)
                        {
                            rollback.TrackFilePatternList = ((List<object>)pair.Value).ConvertToStringList();
                        }
                        break;
                    default:
                        throw new FormatException("Unknown key was specified.");
                    }
                }
                catch (Exception)
                {
                    Console.Error.WriteLine("ERROR: Error has occured at '{0}'. ", pair.Key);
                    throw;
                }
            }

            string error;
            if (!rollback.Validate(out error))
            {
                Console.Error.WriteLine(error);

                throw new FormatException("Required items have not been completed.");
            }
            return rollback;
        }

        private static class RollbackElement
        {
            /// <summary>
            /// Zarf ndi-rollback.json の sigUnchanged オブジェクトに対応するものです。
            /// これに該当しないパスが filesNotTracked オブジェクトに対応します。
            ///
            /// 将来的に、sigModified オブジェクト, filesDeleted オブジェクトに対応するものを指定したくなったときは、
            /// それぞれ、次の定義を追加することを想定しています。
            /// ・ModifyFiles (sigModified)
            /// ・DeleteFiles (filesDeleted)
            /// </summary>
            public const string TrackFiles = "TrackFiles";
        }
    }
}
