﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.IO;
using System.Text;
using System.Threading;
using TestRunner.Executer;

var buildContext = ObjectSerializer.Deserialize<BuildContext>(
    File.ReadAllText(Args[1], Encoding.UTF8));

var listener = string.IsNullOrEmpty(buildContext.ListenerName)
    ? null
    : EventWaitHandle.OpenExisting(buildContext.ListenerName);

var notifier = string.IsNullOrEmpty(buildContext.NotifierName)
    ? null
    : EventWaitHandle.OpenExisting(buildContext.NotifierName);

try
{
    TestExecuter[] executers =
        TestExecuter.Start(buildContext.TestContexts, false);

    listener?.WaitOne();

    TestExecuter.WaitForExit(executers);

    if (buildContext.EnablesVerboseMode)
    {
        foreach (TestContext testContext in buildContext.TestContexts)
        {
            var text = File.ReadAllText(testContext.LogPath, Encoding.UTF8);

            text = text.Replace("\r\n", "\n");

            Console.Write(text);
        }
    }
}
catch (TestContextException ex)
{
    File.AppendAllText(
        ex.TestContext.Path, ObjectSerializer.Serialize(ex.TestContext),
        Encoding.UTF8);
}
finally
{
    notifier?.Set();
}
