﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace SystemUpdaterNx.Install
{
    using System;
    using Properties;
    using TargetShell.CommandPluginBase;
    using TargetShell.Library;
    using TargetShell.PluginInterface;

    /// <summary>
    /// イントールプラグインの定数定義
    /// </summary>
    public class Constants
    {
        /// <summary>
        /// サブコマンド install の文字列
        /// <summary>
        public const string SubCommand = "install";
        /// <summary>
        /// オプション force の文字列
        /// <summary>
        public const string OptionForce = "force";
        /// <summary>
        /// オプション location の文字列
        /// <summary>
        public const string OptionLocation = "location";
        /// <summary>
        /// オプション path の文字列
        /// <summary>
        public const string OptionPath = "path";
        /// <summary>
        /// オプション type の文字列
        /// <summary>
        public const string OptionType = "type";
    }

    /// <summary>
    /// サブコマンドのオプション引数
    /// </summary>
    public class SubCommandArgument : BaseCommand<CommandParameter>, ISubCommandArgument
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public SubCommandArgument()
        {
            this.SubCommandName = Constants.SubCommand;
        }

        /// <summary>
        /// コマンドラインパーサにコマンドを登録します。
        /// </summary>
        /// <param name="commandLineParser">コマンドラインパーサです。</param>
        public void RegisterWith(CommandLineParser commandLineParser)
        {
            // サブコマンド
            var subcommand = commandLineParser.ActionCommand
                .AddCommand(Constants.SubCommand);
            subcommand
                .GetBuilder()
                .SetDescription(SetupTargetResources.InstallDescription);

            // 共通オプション
            this.OptionArgs.CommonArgs.RegisterWith(subcommand);

            // サブコマンド固有のオプション
            subcommand
                .AddValueOption(Constants.OptionType,
                        new Action<string>(x => this.DevicePluginArgs.Type = x))
                .GetBuilder()
                .SetDescription(SetupTargetResources.InstallDescriptionType);
            subcommand
                .AddValueOption(Constants.OptionPath,
                        new Action<string>(x => this.DevicePluginArgs.Path = x))
                .GetBuilder()
                .SetDescription(SetupTargetResources.InstallDescriptioPath);
            subcommand
                .AddFlagOption(Constants.OptionForce,
                        new Action(() => this.DevicePluginArgs.Force = true))
                .GetBuilder()
                .SetDescription(SetupTargetResources.InstallDescriptionForce);
            subcommand
                .AddValueOption(Constants.OptionLocation,
                        new Action<string>(x => this.DevicePluginArgs.Location = x))
                .GetBuilder()
                .SetDescription(SetupTargetResources.InstallDescriptionLocation);
        }
    }
}
