﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace PrivateNx.WriteBootConfig
{
    /// <summary>
    /// BootConfig書き換えで使用する定数
    /// </summary>
    public static class ConstantsSdev
    {
        /// <summary>
        /// キャレット文字。値に入れ替えに使用する
        /// </summary>
        public const string Caret = "^";

        /// <summary>
        /// コマンドで使用する文字列定義一覧
        /// </summary>
        public static class CommandString
        {
            /// <summary>
            /// キータイプ１の文字列
            /// </summary>
            public const string KeyTypeK1 = @"K1";
            /// <summary>
            /// キータイプ２の文字列
            /// </summary>
            public const string KeyTypeK2 = @"K2";
            /// <summary>
            /// キータイプ３の文字列
            /// </summary>
            public const string KeyTypeK3 = @"K3";
            /// <summary>
            /// キータイプ５の文字列
            /// </summary>
            public const string KeyTypeK5 = @"K5";
            /// <summary>
            /// キータイプM2の文字列
            /// </summary>
            public const string KeyTypeM2 = @"M2";
            /// <summary>
            /// 署名ありの文字列
            /// </summary>
            public const string SignedString = @"Signed";
            /// <summary>
            /// 署名なしの文字列
            /// </summary>
            public const string UnsignedString = @"Unsigned";
        }

        /// <summary>
        /// HardwareConfigからKeyTypeに変更するコンバート情報を持つクラス
        /// </summary>
        public class ConvertHardwareConfigToKeyType
        {
            public string[,] ConvertHardwareConfigToKeyTypeTable
            {
                get { return this.convertHardwareConfigToKeyTypeTable; }
            }
            /// <summary>
            /// HardwareConfigからKeyTypeに変更するコンバートテーブル
            /// </summary>
            private string[,] convertHardwareConfigToKeyTypeTable =
            {
                {
                    "1", "K1"
                },
                {
                    "2", "K1"
                },
                {
                    "3", "K2"
                },
                {
                    "4", "K1"
                },
                {
                    "5", "K3"
                },
                {
                    "6", "K3"
                },
                {
                    "7", "K5"
                },
                {
                    "9", "M2"
                },
            };
        }

        /// <summary>
        /// ControlTargetPrivate.exe へのパス
        /// </summary>
        public const string ControlTargetPrivate = @"Tools\CommandLineTools\" +
                @"ControlTargetPrivate.exe";

        /// <summary>
        /// UpdateHostBridge.exe へのパス
        /// </summary>
        public const string UpdateHostBridge = @"Tools\CommandLineTools\" +
                @"UpdateHostBridge.exe";

        /// <summary>
        /// RecoveryBoot.exe へのパス
        /// </summary>
        public const string RecoveryBoot = @"Tools\CommandLineTools\RecoveryBoot.exe";

        /// <summary>
        /// GPIOControllerCUI.exe へのパス
        /// </summary>
        public const string GPIOControllerCUI = @"Externals\HostBridge\tools\" +
                @"HostBridgeController\Resources\GPIOControllerCUI\GPIOControllerCUI.exe";

        /// <summary>
        /// HostBridge関係の定数
        /// </summary>
        public static class HostBridge
        {
            // HostBridge関係
            /// <summary>
            /// HostBridge更新の最大リトライ回数
            /// </summary>
            public const int MaxRetry = 4;
            /// <summary>
            /// package.nhf へのパス
            /// </summary>
            public const string Package = @"Externals\HostBridge\images\package.nhf";

            // Hardware関係
            /// <summary>
            /// HostBridgeHardwareの最新バージョン
            /// </summary>
            public const int LatestHardware = 7;
            /// <summary>
            /// HostBridgeHardwareを記載する文字列
            /// </summary>
            public const string HardwareText = "###HardwareVersion=";

            // Firmware関係
            /// <summary>
            /// HostBridgeFirmwareの最新バージョン
            /// </summary>
            public const string LatestFirmware = "3.11 Tue, 11 Jul 2017 15:56:22 -0700";
            /// <summary>
            /// RecoveryFirmwareを行うかチェック用文字列
            /// </summary>
            public const string CheckStringsRecoveryFirmware = ".IsRecoveryUpdateRequired=True";
            /// <summary>
            /// recovery.nhf へのパス
            /// </summary>
            public const string RecoveryImage = @"Externals\HostBridge\images\recovery.nhf";
        }

        /// <summary>
        /// EmmcWriter.img へのパス
        /// </summary>
        public const string EmmcWriterK1 = @"Externals\NxSystemImages\QspiBootTools\" +
                @"EmmcWriter.img";

        /// <summary>
        /// EmmcWriter2ndKey.img へのパス
        /// </summary>
        public const string EmmcWriterK2 = @"Externals\NxSystemImages\QspiBootTools\" +
                @"EmmcWriter2ndKey.img";

        /// <summary>
        /// EmmcWriter3rdKey.img へのパス
        /// </summary>
        public const string EmmcWriterK3 = @"Externals\NxSystemImages\QspiBootTools\" +
                @"EmmcWriter3rdKey.img";

        /// <summary>
        /// EmmcWriter-K5.img へのパス
        /// </summary>
        public const string EmmcWriterK5 = @"Externals\NxSystemImages\QspiBootTools\" +
                @"EmmcWriter-K5.img";

        /// <summary>
        /// EmmcWriter-M2.img へのパス
        /// </summary>
        public const string EmmcWriterM2 = @"Externals\NxSystemImages\QspiBootTools\" +
                @"EmmcWriter-M2.img";

        /// <summary>
        /// params-bc-1.bin へのパス
        /// </summary>
        public const string ParamsBc1 = @"Externals\NxSystemImages\QspiBootTools\" +
                @"params-bc-1.bin";

        /// <summary>
        /// params-bc-2.bin へのパス
        /// </summary>
        public const string ParamsBc2 = @"Externals\NxSystemImages\QspiBootTools\" +
                @"params-bc-2.bin";

        /// <summary>
        /// params-bc-3.bin へのパス
        /// </summary>
        public const string ParamsBc3 = @"Externals\NxSystemImages\QspiBootTools\" +
                @"params-bc-3.bin";

        /// <summary>
        /// params-bc-4.bin へのパス
        /// </summary>
        public const string ParamsBc4 = @"Externals\NxSystemImages\QspiBootTools\" +
                @"params-bc-4.bin";

        /// <summary>
        /// BootConfig書き込み用ファイル(bc-[シリアル番号].bin) へのパス
        /// </summary>
        public const string BootConfigFile = @"Externals\NxBootConfigs\bc-" + Caret + @".bin";

        /// <summary>
        /// ダミーBootConfig書き込み用ファイル へのパス
        /// </summary>
        public const string DummyBootConfigFile = @"Externals\NxBootConfigs\bc-dummy.bin";

        /// <summary>
        /// デバイスの起動待ちの最大回数
        /// </summary>
        public const int MaxWaitStartUpDevice = 30;

        /// <summary>
        /// ControlTargetPrivate.exe へのパス
        /// </summary>
        public const string ControlTargetPrivatePath = @"Tools\CommandLineTools\" +
                @"ControlTargetPrivate.exe";
    }
}
