﻿#
# 変更履歴を収集・作成する
#
#---------------- パッケージ別情報
$PackageInfo = @(
   # 表示用文字列、収集設定ファイル(ja/en)、出力設定ファイル(ja/en)、出力フォルダ名
   @(
        "NintendoSDK NX",
        @("ja\GatherConfig_NX.xml", "en\GatherConfig_NX.xml"),
        @("ja\ChangeLogConfig_NX.xml", "en\ChangeLogConfig_NX.xml" ),
        "NintendoSDK_NX"
    ),
    @(
        "NintendoSDK",
        @("ja\GatherConfig.xml", "en\GatherConfig.xml"),
        @("ja\ChangeLogConfig.xml", "en\ChangeLogConfig.xml" ),
        "NintendoSDK"
    ),
    @(
        "OceanKit",
        @("ja\GatherConfig_OceanKit.xml", "en\GatherConfig_OceanKit.xml"),
        @("ja\ChangeLogConfig_Oceankit.xml", "en\ChangeLogConfig_OceanKit.xml" ),
        "OceanKit"
    ),
    @(
        "ControllerKit",
        @("ja\GatherConfig_ControllerKit.xml", "en\GatherConfig_ControllerKit.xml"),
        @("ja\ChangeLogConfig_ControllerKit.xml", "en\ChangeLogConfig_ControllerKit.xml" ),
        "ControllerKit"
    ),
    @(
        "AppletKit",
        @("ja\GatherConfig_AppletKit.xml", "en\GatherConfig_AppletKit.xml"),
        @("ja\ChangeLogConfig_AppletKit.xml", "en\ChangeLogConfig_AppletKit.xml" ),
        "AppletKit"
    ),
    @(
        "NetworkMiddlewareKit",
        @("ja\GatherConfig_NetworkMiddlewareKit.xml", "en\GatherConfig_NetworkMiddlewareKit.xml"),
        @("ja\ChangeLogConfig_NetworkMiddlewareKit.xml", "en\ChangeLogConfig_NetworkMiddlewareKit.xml" ),
        "NetworkMiddlewareKit"
    ),
    @(
        "NetworkMiddlewarekit NX",
        @("ja\GatherConfig_NetworkMiddlewareKitNX.xml", "en\GatherConfig_NetworkMiddlewareKitNX.xml"),
        @("ja\ChangeLogConfig_NetworkMiddlewareKitNX.xml", "en\ChangeLogConfig_NetworkMiddlewareKitNX.xml" ),
        "NetworkMiddlewarekit_NX"
    ),
    @(
        "PlayReportKit",
        @("ja\GatherConfig_PlayReportKit.xml", "en\GatherConfig_PlayReportKit.xml"),
        @("ja\ChangeLogConfig_PlayReportKit.xml", "en\ChangeLogConfig_PlayReportKit.xml" ),
        "PlayReportKit"
    ),
    @(
        "TurboSKit",
        @("ja\GatherConfig_TurboSKit.xml", "en\GatherConfig_TurboSKit.xml"),
        @("ja\ChangeLogConfig_TurboSKit.xml", "en\ChangeLogConfig_TurboSKit.xml" ),
        "TurboSKit"
    ),
    @(
        "UnityKit"
        @("ja\GatherConfig_UnityKit.xml", "en\GatherConfig_UnityKit.xml"),
        @("ja\ChangeLogConfig_UnityKit.xml", "en\ChangeLogConfig_UnityKit.xml" ),
        "UnityKit"
    ),
    @(
        "VodDevelopmentKit"
        @("ja\GatherConfig_VodDevelopmentKit.xml", "en\GatherConfig_VodDevelopmentKit.xml"),
        @("ja\ChangeLogConfig_VodDevelopmentKit.xml", "en\ChangeLogConfig_VodDevelopmentKit.xml" ),
        "VodDevelopmentKit"
    ),
    @(
        "LaboKit"
        @("ja\GatherConfig_LaboKit.xml", "en\GatherConfig_LaboKit.xml"),
        @("ja\ChangeLogConfig_LaboKit.xml", "en\ChangeLogConfig_LaboKit.xml" ),
        "LaboKit"
    ),
    @(
        "AudioInKit"
        @("ja\GatherConfig_AudioInKit.xml", "en\GatherConfig_AudioInKit.xml"),
        @("ja\ChangeLogConfig_AudioInKit.xml", "en\ChangeLogConfig_AudioInKit.xml" ),
        "AudioInKit"
    ),
    @(
        "HidbusApplicationKit"
        @("ja\GatherConfig_HidbusApplicationKit.xml", "en\GatherConfig_HidbusApplicationKit.xml"),
        @("ja\ChangeLogConfig_HidbusApplicationKit.xml", "en\ChangeLogConfig_HidbusApplicationKit.xml" ),
        "HidbusApplicationKit"
    ),
    @(
        "ParkKit"
        @("ja\GatherConfig_ParkKit.xml", "en\GatherConfig_ParkKit.xml"),
        @("ja\ChangeLogConfig_ParkKit.xml", "en\ChangeLogConfig_ParkKit.xml" ),
        "ParkKit"
    ),
    @(
        "BluetoothApplicationKit"
        @("ja\GatherConfig_BluetoothApplicationKit.xml", "en\GatherConfig_BluetoothApplicationKit.xml"),
        @("ja\ChangeLogConfig_BluetoothApplicationKit.xml", "en\ChangeLogConfig_BluetoothApplicationKit.xml" ),
        "BluetoothApplicationKit"
    ),
    @(
        "CircleKit"
        @("ja\GatherConfig_CircleKit.xml", "en\GatherConfig_CircleKit.xml"),
        @("ja\ChangeLogConfig_CircleKit.xml", "en\ChangeLogConfig_CircleKit.xml" ),
        "CircleKit"
    ),
    @(
        "BelugaKit"
        @("ja\GatherConfig_BelugaKit.xml", "en\GatherConfig_BelugaKit.xml"),
        @("ja\ChangeLogConfig_BelugaKit.xml", "en\ChangeLogConfig_BelugaKit.xml" ),
        "BelugaKit"
    )
)

#---------------- 定数定義
set-variable -name INDEX_NAME          -value 0 -option constant
set-variable -name INDEX_GATHER_CONFIG -value 1 -option constant
set-variable -name INDEX_OUTPUT_CONFIG -value 2 -option constant
set-variable -name INDEX_OUTPUT_DIR    -value 3 -option constant

set-variable -name INDEX_JA -value 0 -option constant
set-variable -name INDEX_EN -value 1 -option constant

set-variable -name ACTION_NONE   -value "-1" -option constant
set-variable -name ACTION_DISPLAY -value 0 -option constant
set-variable -name ACTION_GATHER -value 1 -option constant
set-variable -name ACTION_OUTPUT -value 2 -option constant

#--------------------------------------------------------------------------------
function Show-InputUserForm()
{
  # アセンブリのロード
  Add-Type -AssemblyName System.Windows.Forms
  Add-Type -AssemblyName System.Drawing

  # フォームの作成
  $form = New-Object System.Windows.Forms.Form
  $form.Text = "ユーザ名とパスワード入力"
  $form.Size = New-Object System.Drawing.Size(280,260)
  $form.StartPosition = "CenterScreen"

  # OKボタンの設定
  $OKButton = New-Object System.Windows.Forms.Button
  $OKButton.Location = New-Object System.Drawing.Point(50,170)
  $OKButton.Size = New-Object System.Drawing.Size(75,30)
  $OKButton.Text = "OK"
  $OKButton.DialogResult = "OK"

  # キャンセルボタンの設定
  $CancelButton = New-Object System.Windows.Forms.Button
  $CancelButton.Location = New-Object System.Drawing.Point(140,170)
  $CancelButton.Size = New-Object System.Drawing.Size(75,30)
  $CancelButton.Text = "Cancel"
  $CancelButton.DialogResult = "Cancel"

  # ラベルの設定
  $label = New-Object System.Windows.Forms.Label
  $label.Location = New-Object System.Drawing.Point(20,50)
  $label.Size = New-Object System.Drawing.Size(250,20)
  $label.Text = "User"

  $label2 = New-Object System.Windows.Forms.Label
  $label2.Location = New-Object System.Drawing.Point(20,100)
  $label2.Size = New-Object System.Drawing.Size(250,20)
  $label2.Text = "Password"

  $label3 = New-Object System.Windows.Forms.Label
  $label3.Location = New-Object System.Drawing.Point(20,10)
  $label3.Size = New-Object System.Drawing.Size(250,30)
  $label3.Text = "認証ファイルがありません。`r`nJIRA アカウントを入力してください。"

  # 入力ボックスの設定
  $textBox = New-Object System.Windows.Forms.TextBox
  $textBox.Location = New-Object System.Drawing.Point(40,70)
  $textBox.Size = New-Object System.Drawing.Size(185,50)

  $textBox2 = New-Object System.Windows.Forms.TextBox
  $textBox2.Location = New-Object System.Drawing.Point(40,120)
  $textBox2.Size = New-Object System.Drawing.Size(185,50)
  $textBox2.PasswordChar = "*"

  # キーとボタンの関係
  $form.AcceptButton = $OKButton
  $form.CancelButton = $CancelButton

  # ボタン等をフォームに追加
  $form.Controls.Add($OKButton)
  $form.Controls.Add($CancelButton)
  $form.Controls.Add($label)
  $form.Controls.Add($label2)
  $form.Controls.Add($label3)
  $form.Controls.Add($textBox)
  $form.Controls.Add($textBox2)

  # フォームを表示させ、その結果を受け取る
  $result = $form.ShowDialog()

  # 結果による処理分岐
  if ($result -eq "OK")
  {
      # Write-Host $textBox.Text $textBox2.Text
      return $textBox.Text, $textBox2.Text
  }
  else
  {
      return $null, $null
  }
}

#--------------------------------------------------------------------------------
function Show-InputForm()
{
  # アセンブリのロード
  Add-Type -AssemblyName System.Windows.Forms
  Add-Type -AssemblyName System.Drawing

  # フォームを作る
  $Form = New-Object System.Windows.Forms.Form
  $Form.Size = New-Object System.Drawing.Size(500,450)
  $Form.Text = "Create ReleaseNote"
  $Form.StartPosition = "CenterScreen"

  #----------------
  # Package グループ
  $PackageG = New-Object System.Windows.Forms.GroupBox
  $PackageG.Location = New-Object System.Drawing.Point(10,10)
  $PackageG.size = New-Object System.Drawing.Size(300,390)
  $PackageG.text = "Package"

  $x = 20
  $y = 20
  [System.Windows.Forms.RadioButton[]]$PackageB = @()
  for( $i=0; $i -lt $PackageInfo.Length; $i++ )
  {
      $PackageB += New-Object System.Windows.Forms.RadioButton
      $PackageB[$i].Location = New-Object System.Drawing.Point( $x, $y )
      $PackageB[$i].Size     = New-Object System.Drawing.Size( 270, 20 )
      $PackageB[$i].Text     = $PackageInfo[$i][$INDEX_NAME]
      $y += 20
  }
  $PackageB[0].Checked = $True
  $PackageG.Controls.AddRange( $PackageB )

  #----------------
  # 言語グループ
  $LanguageG = New-Object System.Windows.Forms.GroupBox
  $LanguageG.Location = New-Object System.Drawing.Point(320, 140)
  $LanguageG.size = New-Object System.Drawing.Size(150,100)
  $LanguageG.text = "Language"

  # 言語
  $LanguageB1 = New-Object System.Windows.Forms.RadioButton
  $LanguageB1.Location = New-Object System.Drawing.Point(10,20)
  $LanguageB1.size = New-Object System.Drawing.Size(120,30)
  $LanguageB1.Text = "Japanese"
  $LanguageB1.Checked = $True

  $LanguageB2 = New-Object System.Windows.Forms.RadioButton
  $LanguageB2.Location = New-Object System.Drawing.Point(10,50)
  $LanguageB2.size = New-Object System.Drawing.Size(120,30)
  $LanguageB2.Text = "English"

  $LanguageG.Controls.AddRange(@($LanguageB1,$LanguageB2))

  #----------------
  # Gather動作 グループ
  $GatherActG = New-Object System.Windows.Forms.GroupBox
  $GatherActG.Location = New-Object System.Drawing.Point(320,10)
  $GatherActG.size = New-Object System.Drawing.Size(150,90)
  $GatherActG.text = "Action"

  # 動作
  $GatherActB1 = New-Object System.Windows.Forms.CheckBox
  $GatherActB1.Location = New-Object System.Drawing.Point(10,20)
  $GatherActB1.size = New-Object System.Drawing.Size(120,30)
  $GatherActB1.Text = "Gather *.dat"
  $GatherActB1.Checked = $True

  $GatherActB2 = New-Object System.Windows.Forms.CheckBox
  $GatherActB2.Location = New-Object System.Drawing.Point(10,50)
  $GatherActB2.size = New-Object System.Drawing.Size(120,30)
  $GatherActB2.Text = "Output ChangeLog"
  $GatherActB2.Checked = $True

  $GatherActG.Controls.AddRange(@($GatherActB1,$GatherActB2))

  #----------------
  # OKボタンを作る
  $OKButton = new-object System.Windows.Forms.Button
  $OKButton.Location = New-Object System.Drawing.Point(320,250)
  $OKButton.Size = New-Object System.Drawing.Size(70,30)
  $OKButton.Text = "作成"
  $OKButton.DialogResult = "OK"

  # キャンセルボタンを作る
  $CancelButton = new-object System.Windows.Forms.Button
  $CancelButton.Location = New-Object System.Drawing.Point(400,250)
  $CancelButton.Size = New-Object System.Drawing.Size(70,30)
  $CancelButton.Text = "キャンセル"
  $CancelButton.DialogResult = "Cancel"

  # チェッククリアボタンを作る
  $ClearCheckButton = new-object System.Windows.Forms.Button
  $ClearCheckButton.Location = New-Object System.Drawing.Point(325,108)
  $ClearCheckButton.Size = New-Object System.Drawing.Size(135,20)
  $ClearCheckButton.Text = "表示のみなのでクリア"
  $eventForClearCheckButton = {
      $GatherActB1.Checked = $false
      $GatherActB2.Checked = $false
      [System.Windows.Forms.Form]::Invalidate
  }
  $ClearCheckButton.add_Click( $eventForClearCheckButton )

  #----------------
  # フォームに各アイテムを入れる
  $Form.Controls.AddRange(@($PackageG, $LanguageG, $GatherActG, $OKButton, $CancelButton, $ClearCheckButton))

  # Enterキー、Escキーと各ボタンの関連付け
  $Form.AcceptButton = $OKButton
  $Form.CancelButton = $CancelButton

  # フォームをアクティブにする＝Topmost？
  $Form.TopMost = $True

   # フォームを表示させ、押されたボタンの結果を受け取る
  $dialogResult = $Form.ShowDialog()

  if ( $dialogResult -eq "OK" )
  {
      # ボタン押下による条件分岐
      for( $i=0; $i -lt $PackageInfo.Length; $i++ )
      {
          if ( $PackageB[$i].Checked )
          {
              $package = $i
          }
      }

      $action = 0
      if ($GatherActB1.Checked){ $action += $ACTION_GATHER }
      if ($GatherActB2.Checked){ $action += $ACTION_OUTPUT }

      if ($LanguageB1.Checked){ $language = $INDEX_JA }
      if ($LanguageB2.Checked){ $language = $INDEX_EN }

  }
  else
  {
      $package = $null
      $action = $ACTION_NONE
      $language = $null
  }
  return $action, $package, $language
}

#--------------------------------------------------------------------------------
function Show-Dialog( [ref]$text, [ref]$caption, $itype )
{
  Set-StrictMode -version Latest
  Add-Type -AssemblyName System.Windows.Forms;

  $private:buttonsType = "OK"
  $result = [System.Windows.Forms.MessageBox]::Show($text.value, $caption.value, $buttonsType, $itype);
}
#--------------------------------------------------------------------------------
function Show-DialogOkCancel( [ref]$text, [ref]$caption, $itype )
{
  Set-StrictMode -version Latest
  Add-Type -AssemblyName System.Windows.Forms;

  $private:buttonsType = "OKCancel"
  $result = [System.Windows.Forms.MessageBox]::Show($text.value, $caption.value, $buttonsType, $itype);
  return $result
}

#================================================================================
#  メイン処理
#

#---- 動作を決定
$action, $package, $language = Show-InputForm

#---- キャンセルの場合終了
if ( $action -eq $ACTION_NONE )
{
    exit
}

#---- 確認
[string[]]$text = @()
$text += ("{0} の変更履歴:`r`n" -f $PackageInfo[$package][$INDEX_NAME])
$text += "`r`n"

if ( $action -eq $ACTION_GATHER )
{
    $text += "履歴データの収集だけを行います。変更履歴は出力しません。`r`n"
}
elseif ( $action -eq $ACTION_OUTPUT )
{
    $text += "履歴データの収集は行わず、変更履歴を出力します。`r`n"
}
elseif ( $action -eq $ACTION_DISPLAY )
{
    $text += "すでに作成されている変更履歴を表示します。"
}
else
{
    $text += "履歴データの収集を収集し、変更履歴を出力します。`r`n"
}
$result = Show-DialogOkCancel ([ref]$text) ([ref]"動作の確認") "Information"

if ( $result -eq "Cancel" )
{
    exit
}

#---- 言語の考慮
$LangDir = $(if ( $language -eq $INDEX_JA ){ "ja" }else{ "en" } )
$EnglishOption = $(if ( $language -eq $INDEX_JA ){ "" }else{ "-English" } )

# 出力先
$OutputDir = ".\Outputs\" + $PackageInfo[$package][$INDEX_OUTPUT_DIR] + "\" + $LangDir + "\Package\contents"

# 認証情報
$AuthFile = ".\config\Authentication.xml"

# コンフィルファイル
$GatherConfigFile = ".\config\" + $PackageInfo[$package][$INDEX_GATHER_CONFIG][$language]
$OutputConfigFile = ".\config\" + $PackageInfo[$package][$INDEX_OUTPUT_CONFIG][$language]

# Alias ファイル
$AliasFile = ".\config\Aliases.xml"

# コンポーネントルールファイル
$ComponentRuleFile = ".\config\componentRule.json"

# API リファレンス一
$PreUrl = "../../../../../../../../Documents/Outputs/Html/"

# CSS など template 置き場
$TemplateDir = "..\..\..\..\Externals\documenttools\FairlyLinguistCui\DocumentTemplate\default\common\contents\template"


if ( $action -band ( $ACTION_GATHER -band $ACTION_GATHER ) -ne 0 )
{
#---- ファイル存在確認
    #-- Alias ファイル確認
    if ( ! ( Test-Path -path $AliasFile ) )
    {
        $text = @()
        $text += $AliasFile + " が存在しません。`r`n"
        Show-Dialog ([ref]$text) ([ref]"エラー") "Error"
        exit
    }
}

if ( ($action -band $ACTION_GATHER) -ne 0 )
{
    #-- 認証情報ファイル確認
    if ( ! ( Test-Path -path $AuthFile ) )
    {
        $User, $Password = Show-InputUserForm
        if ( $User -eq $null -or $Password -eq $null )
        {
            exit
        }
        if ( $User -eq "" -or $Password -eq "" )
        {
            $text = @()
            $text += "入力が不正なので終了します。`r`n"
            Show-Dialog ([ref]$text) ([ref]"エラー") "Error"
            exit
        }
        $IsUseAuthFile = $false
    }
    else
    {
        $IsUseAuthFile = $true
    }
    #-- コンポーネントルールファイル確認
    if ( ! ( Test-Path -path $ComponentRuleFile ) )
    {
        $text = @()
        $text += $ComponentRuleFile + " が存在しません。`r`n"
        Show-Dialog ([ref]$text) ([ref]"エラー") "Error"
        exit
    }
    #-- 収集設定確認
    if ( ! ( Test-Path -path $GatherConfigFile ) )
    {
        $text = @()
        $text += $GatherConfigFile + " が存在しません。`r`n"
        Show-Dialog ([ref]$text) ([ref]"エラー") "Error"
        exit
    }
}
if ( ($action -band $ACTION_OUTPUT) -ne 0 )
{
    #-- 出力設定確認
    if ( ! ( Test-Path -path $OutputConfigFile ) )
    {
        $text = @()
        $text += $OutputConfigFile + " が存在しません。`r`n"
        Show-Dialog ([ref]$text) ([ref]"エラー") "Error"
        exit
    }
}

#---- 作業フォルダの変更
$CommandDir = Split-Path $script:myInvocation.MyCommand.path -parent
cd $CommandDir

#---- 履歴情報の取得
if ( ($action -band $ACTION_GATHER) -ne 0 )
{
    if ( $IsUseAuthFile )
    {
        $args = ( "-AuthenticationFile", $AuthFile, "-AliasFile", $AliasFile, "-ComponentRuleFile", $ComponentRuleFile, "-ConfigFile", $GatherConfigFile, "-CheckHtml", $EnglishOption )
        powershell -Version 2.0  -ExecutionPolicy ByPass -NoProfile .\gatherChangeLog.ps1 $args
    }
    else
    {
        $args = ( "-User", "$User", "-Password", "'$Password'", "-AliasFile", $AliasFile, "-ComponentRuleFile", $ComponentRuleFile, "-ConfigFile", $GatherConfigFile, "-CheckHtml", $EnglishOption )
        powershell -Version 2.0  -ExecutionPolicy ByPass -NoProfile .\gatherChangeLog.ps1 $args
    }
}

#---- 変更履歴の出力
if ( ($action -band $ACTION_OUTPUT) -ne 0 )
{
    if ( $IsUseAuthFile )
    {
        $args = @( "-AuthenticationFile", $AuthFile, "-OutputDir", $OutputDir, "-PreApiUrl", $PreUrl, "-AliasFile", $AliasFile, "-ConfigFile", $OutputConfigFile, $EnglishOption )
        powershell -Version 2.0  -ExecutionPolicy ByPass -NoProfile .\outputChangeLog.ps1 $args

    }
    else
    {
        $args = @( "-OutputDir", $OutputDir, "-PreApiUrl", $PreUrl, "-AliasFile", $AliasFile, "-ConfigFile", $OutputConfigFile, $EnglishOption )
        powershell -Version 2.0  -ExecutionPolicy ByPass -NoProfile .\outputChangeLog.ps1 $args
    }
    Copy-Item -Path html\Resources\tocData.js $OutputDir\
    Copy-Item -Path html\Resources\template $OutputDir -Recurse -Force
    Copy-Item $TemplateDir $OutputDir -Recurse -Force
}

#---- 完了のダイアログ
if ( $action -eq $ACTION_GATHER )
{
    $text = @()
    $text += "完了しました。"
    Show-Dialog ([ref]$text) ([ref]"完了") "Information"
}
elseif ( $action -eq $ACTION_DISPLAY )
{
    if ( -not (Test-Path -path $OutputDir\ChangeLog.html) )
    {
        $text = @()
        $text += "$OutputDir\ChangeLog.html" + " が存在しません。`r`n"
        Show-Dialog ([ref]$text) ([ref]"エラー") "Error"
        exit
    }

    Invoke-Item $OutputDir\ChangeLog.html
}
else
{
    $text = @()
    $text += "完了しました。`r`n"
    $text += "`r`n"
    $text += "作成した変更履歴をブラウザで開きますか?`r`n"
    $text += ("ファイル: {0}\ChangeLog.html" -f $OutputDir)
    $result = Show-DialogOkCancel ([ref]$text) ([ref]"完了") "Information"
    if ( $result -eq "Ok" )
    {
        Invoke-Item $OutputDir\ChangeLog.html
    }
}
