#
#  ύXpԃt@C|˗p XML ֕ϊ
#
#  COMMAND [-InFile <file>] [-OutFile <file>] [-Detail]
#
#       -InFile <file>     ̓t@C
#       -OutFile <file>    o̓t@CBȗ͓̓t@Cɑ΂ .xml
#       -Detail            ̏ڍׂɕ\BȗŁAȗ͏ڍׂ\ȂB
#
#  ()
#  COMMAND -InFile aaa.dat -OutFile bbb.xml -Detail
#
#      xxxx.dat Axxx.ex.xml ւƕϊ
#
#----------------------------------------------------------------
param
(
    [Parameter(Mandatory=$true)]
    [string]$InFile = "",

    [string]$OutFile = "",
    [switch]$Detail
)

#---- o̓t@C
if ( $OutFile -eq "" )
{
    $base = $InFile -replace ".dat$",""
    $OutFile = $base + ".ex.xml"
}

$Indent1 = "  "
$Indent2 = "    "
$Indent3 = "      "

$OutXml = @()

#----------------------------------------------------------------
#
function ConvertTo-XmlStr( $s, $indent )
{
    $c0 = $s
    $c = ""
    while($true)
    {
        if ( $c0 -match "(.*?)\\r\\n(.*)" )
        {
            $c += $indent + "<Line><![CDATA[" + ($matches[1] -replace "`]]>","]]&gt;" -replace "`\`\`\`\","`\" ) + "]]></Line>`r`n"
            $c0 = $matches[2]
        }
        else
        {
            $c += $indent + "<Line><![CDATA[" + ($c0 -replace "]]>","]]&gt;" -replace "`\`\`\`\","`\" ) + "]]></Line>`r`n"
            break
        }
   }
    return ($c -replace "`r`n$")
}

#================================================================================
if ( $Detail -ne $false )
{
    Write-Host( "*** Convert from {0} to {1}." -f $InFile, $OutFile)
}


$OutXml += "<?xml version=`"1.0`"?>"
$OutXml += "<ReleaseNote>"

$OutXml += $Indent1 + ("<FileName>{0}</FileName>" -f $(Get-ChildItem $InFile).Name )

$n = 0
foreach ($line in Get-Content $InFile)
{
    #---- 擪V[vȂRg
    if ( $line -match "^#" )
    {
        if ( $line -match "DataVersion = ([0-9a-zA-Z]*)" )
        {
            $OutXml += $Indent1 + ("<DataVersion>{0}</DataVersion>" -f $matches[1])
        }
        continue
    }
    #---- sXLbv
    if ( $line.Trim() -eq "" )
    {
        continue
    }

    #---- line  CSV 
    $c = $line | ConvertFrom-Csv -Delimiter "," -Header HASH,LANG,KEY,CATEGORY,PRIORITY,PACKAGE,COMPONENT_JA,COMPONENT_EN,COMPONENT_CAT,TITLE,CONTENT,FIXVERSION,DATE

    #Write-Host $c.HASH
    #Write-Host $c.TITLE
    #Write-Host $c.CONTENT

    $OutXml += $Indent1 + ("<Item Id=`"{0}`">" -f $c.HASH)

    $OutXml += $Indent2 + "<Title>"
    $OutXml += (ConvertTo-XmlStr $c.TITLE $Indent3)
    $OutXml += $Indent2 + "</Title>"

    $OutXml += $Indent2 + "<Content>"
    $OutXml += (ConvertTo-XmlStr $c.CONTENT $Indent3)
    $OutXml += $Indent2 + "</Content>"
    $OutXml += $Indent1 + "</Item>"

    $n ++
}

$OutXml += "</ReleaseNote>"
$OutXml += ""

#Write-Host ($OutXml -join "`r`n")

New-Item -force -ItemType file $OutFile | Out-Null
( $OutXml -join "`r`n" ) | Out-File -Encoding UTF8 $OutFile -Append

Write-Host( "*** Converted {0} item(s)." -f $n )
Write-Host "*** Done."
