﻿namespace Nintendo.PlatformCodeFilter

/// 文字列断片を保持する抽象クラスです。
[<AbstractClass>]
type StringSnippet () =
    class
    end


/// defined(マクロ)の文字列断片を保持するクラスです。
type DefinedSnippet (macroString: string, defined: StringRange, openRange: StringRange, macro: StringRange, close: StringRange) =
    inherit StringSnippet ()

    /// マクロ文字列を取得します。
    member this.MacroString = macroString

    /// defined の StringRange を取得します。
    member this.Defined = defined

    /// defined の開き括弧の StringRange を取得します。
    member this.Open = openRange

    /// マクロの StringRange を取得します。
    member this.Macro = macro

    /// defined の閉じ括弧の StringRange を取得します。
    member this.Close = close


/// 単一の文字列断片を保持するクラスです。
type SimpleStringSnippet (snippet: string) =
    inherit StringSnippet ()

    /// 文字列断片を取得します。
    member this.Snippet = snippet


/// StringRangeの文字列断片を保持するクラスです。
type StringRangeSnippet (snippet: StringRange) =
    inherit StringSnippet ()

    /// 文字列断片を取得します。
    member this.Snippet = snippet
