﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;

namespace NxAgingHelper
{
    public class CommandLineArgs
    {
        private HelperCommandParams parameters;

        /// <summary>
        /// 解析した結果のパラメータを渡します。
        /// </summary>
        public HelperCommandParams Params
        {
            get { return parameters; }
        }

        /// <summary>
        /// コマンドラインオプションを解析します
        /// </summary>
        /// <returns>解析の成否</returns>
        public bool ParseArgs(string[] args)
        {
            var settings = new CommandLineParserSettings()
            {
                HelpWriter = text =>
                {
                    Console.WriteLine(text);
                },
            };

            if (!new CommandLineParser(settings).ParseArgs(args, out parameters))
            {
                return false;
            }

            // エラーチェック
            bool ret = true;
            if (parameters.Sdev == null && parameters.Edev == null)
            {
                Console.WriteLine("Error: specify '--sdev' or '--edev'.");
                ret = false;
            }
            if (parameters.Sdev != null && parameters.Edev != null)
            {
                Console.WriteLine("Error: '--sdev' and '--edev' are exclusive.");
                ret = false;
            }
            if (parameters.EnableUartLog && parameters.UartLogPath == null)
            {
                Console.WriteLine("Error: '--uart-log-path' is not specified.");
                ret = false;
            }
            if (parameters.EnableHdmiEvent && parameters.HdmiSwitcherIpAddr == null)
            {
                Console.WriteLine("Error: IP Address of HDMI Switcher is not specified. Use '--hdmi-switcher-ip-addr' option.");
                ret = false;
            }
            if (parameters.EnableMcciEvent && parameters.McciPort == null)
            {
                Console.WriteLine("Error: MCCI 3101 COM port name is not specified. Use '--mcci-port' option.");
                ret = false;
            }
            if (parameters.EnableSdevUsbEvent && parameters.Sdev == null)
            {
                Console.WriteLine("Error: IP Address of SDEV is not specified. Use '--sdev-ip-addr' option.");
                ret = false;
            }
            if (parameters.EnableBatteryEmulationEvent && parameters.Sdev == null)
            {
                Console.WriteLine("Error: IP Address of SDEV is not specified. Use '--sdev-ip-addr' option.");
                ret = false;
            }
            if (parameters.RegExWatchStopAging && !parameters.EnableUartLog)
            {
                Console.WriteLine("Error: RegExWatch is specified but not specified '--enable-uart-log' option.");
                ret = false;
            }
            if (parameters.RegExWatchStopAging && parameters.RegExWatchString == null)
            {
                Console.WriteLine("Error: Regular expression is not specified. Use '--reg-ex' option.");
                ret = false;
            }

            return ret;
        }

        /// <summary>
        /// 引数解析が失敗したときに呼ばれるメソッドです。
        /// </summary>
        /// <param name="errorInfo">エラーの情報</param>
        private void CommandLineParseError(CommandLineErrorInfo errorInfo)
        {
            Console.Error.WriteLine("CommandLine: {0}", errorInfo.ErrorMessage);
        }
    }
}
