﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;

namespace Nintendo.NintendoSdkVsExtension.ViewModels
{
    /// <summary>
    /// ダイアログ用の VM。
    /// </summary>
    public class DialogViewModelBase : Common.BindableBase
    {
        private bool? _dialogResult;

        /// <summary>
        /// (View 用) ダイアログの処理が完了した場合に設定される。ダイアログを閉じることが期待される。
        /// </summary>
        /// <remarks>
        /// ×ボタン等でダイアログが勝手に閉じた場合には設定されていないことに注意。
        /// </remarks>
        public bool? DialogResult
        {
            get { return _dialogResult; }
            set { SetProperty(ref _dialogResult, value); }
        }
    }
}
