﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;

namespace Nintendo.NintendoSdkVsExtension.Controls
{
    public class CellPastableDataGrid : DataGrid
    {
        static CellPastableDataGrid()
        {
            CommandManager.RegisterClassCommandBinding(
                typeof(CellPastableDataGrid), new CommandBinding(
                    ApplicationCommands.Paste, new ExecutedRoutedEventHandler(OnExecutedPaste), new CanExecuteRoutedEventHandler(OnCanExecutePaste)));
        }

        private static void OnCanExecutePaste(object sender, CanExecuteRoutedEventArgs e)
        {
            ((CellPastableDataGrid)sender).OnCanExecutePaste(e);
        }

        private static void OnExecutedPaste(object sender, ExecutedRoutedEventArgs e)
        {
            ((CellPastableDataGrid)sender).OnExecutedPaste(e);
        }

        protected virtual void OnCanExecutePaste(CanExecuteRoutedEventArgs e)
        {
            e.CanExecute = (CurrentCell != null && Clipboard.ContainsText());
            e.Handled = true;
        }

        protected virtual void OnExecutedPaste(ExecutedRoutedEventArgs e)
        {
            var text = GetFirstValueFromClipboard();
            if (string.IsNullOrEmpty(text))
            {
                return;
            }

            foreach (var cell in SelectedCells)
            {
                cell.Column.OnPastingCellClipboardContent(cell.Item, text);
            }

            e.Handled = true;
        }

        // TODO: もっといい感じにする
        private string GetFirstValueFromClipboard()
        {
            var csv = Clipboard.GetText(TextDataFormat.CommaSeparatedValue);
            if (!string.IsNullOrEmpty(csv))
            {
                // TODO: ちゃんとパースする
                return csv.Split(',', '\r', '\n')[0];
            }

            var text = Clipboard.GetText(TextDataFormat.UnicodeText);
            if (!string.IsNullOrEmpty(text))
            {
                return text;
            }

            return string.Empty;
        }
    }
}
