﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Microsoft.VisualStudio;
using Microsoft.VisualStudio.Shell.Interop;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.NintendoSdkVsExtension.Shell
{
    public static class VsHierarchyUtil
    {
        public static T GetProperty<T>(IVsHierarchy h, __VSHPROPID propid)
        {
            object value;
            Microsoft.VisualStudio.ErrorHandler.ThrowOnFailure(
                h.GetProperty(VSConstants.VSITEMID_ROOT, (int)propid, out value));
            return (T)value;
        }

        public static string GetCanonicalName(IVsHierarchy h)
        {
            string s;
            Microsoft.VisualStudio.ErrorHandler.ThrowOnFailure(
                h.GetCanonicalName(VSConstants.VSITEMID_ROOT, out s));
            return s;
        }

        public static string GetProjectPath(IVsHierarchy h)
        {
            var project = h as IVsProject;
            if (project == null)
            {
                throw new ArgumentException("must be IVsProject", nameof(h));
            }

            // IVsProject.GetMkDocument は、ファイルベースのプロジェクトの場合必ずフルパスを返す
            // GetCanonicalName も実際フルパスを返すのだが、ドキュメントされた動作ではない。
            string s;
            Microsoft.VisualStudio.ErrorHandler.ThrowOnFailure(
                project.GetMkDocument(VSConstants.VSITEMID_ROOT, out s));
            return s;
        }
    }

}
