﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>

class NgWordConverter {
public:

    // 実行オプション
    enum ExportAcBinOption
    {
        ExportAcBinOption_DebugOutputs = (1 << 0),    // 確認用の中間ファイルを出力する
    };

public:
    NgWordConverter() : m_Option(0)
    {
        // このプログラムはデフォルトだと
        // $SIGLO_ROOT/Integrate\Outputs\AnyCPU\Tools\NgWordConverter\NgWordConverter\Release
        // から実行されることを想定する
        SetRootPath("../../../../../../../");
    }

    // AhoCorasick バイナリの生成と書き出し
    // 成功したら 0 を返す
    errno_t CreateAcBinary();

    void SetOption(int option)
    {
        m_Option = option;
    }

    // ルートディレクトリパスを変更
    void SetRootPath(std::string rootPath)
    {
        m_RootPath = rootPath;
        if (m_RootPath[m_RootPath.length() - 1] != '/')
        {
            m_RootPath += "/";
        }

        m_NgResourceInputPath = m_RootPath + "Programs/Iris/Resources/NgWord/";
        m_NgResourceOutputPath = m_RootPath + "Programs/Iris/Resources/NgWord2/";
        m_WinHeaderPath = m_RootPath + "Programs/Eris/Sources/Libraries/ngc/detail/ngc_AcAutomaton-os.win32.h";
        m_CopyrightPath = m_RootPath + "Integrate/Sources/Tools/NgWordConverter/NgWordConverter/Copyright.h";
    }

private:

    // エクスポート時に利用するファイルパスが存在するか確認
    // 存在するなら true を返す
    bool CheckDirectoryPath();

    // AhoCorasick バイナリを作成
    // 成功したら 0 を返す
    //  - fileName  生成元ファイル名
    //  - pAcStr    生成するAC バイナリの生成先パス
    //  - acStrSize pAcStr 配列の要素数
    //  - option    オプション
    // ここで生成されるのは nlib succinct ライブラリから出力されたままのもの
    // ここから Windows 向けにはヘッダファイル形式に、 Horizon 向けには圧縮していく
    errno_t CreatePlainAcBinary(std::string fileName, const std::string* pAcStr);

    // Windows 用の AhoCorasick バイナリのヘッダの作成
    // ここでは Copyright の書き込みだけ行う
    //  - pWinHeaderFd  書き込み先ファイルディスクリプタ
    //                  ファイルディスクリプタはこの関数の中で設定され、ファイルオープンされる
    errno_t InitializeAcWinHeader(nlib_fd* pWinHeaderFd);

    // Windows 用の AhoCorasick バイナリのヘッダの作成
    // 名前空間の閉じ括弧の書き込み
    //  - pWinHeaderFd  書き込み先ファイルディスクリプタ
    //                  ファイルディスクリプタはこの関数の中でクローズされ、 0 が設定される
    errno_t FinalizeAcWinHeader(nlib_fd* pWinHdaderFd);

    // Windows 用の AhoCorasick バイナリのヘッダへの書き込み
    // winHeaderFd に対して fileName の AhoCorasick バイナリを書き込み
    // 成功したら 0 を返す
    //  - fileName      生成元ファイル名
    //  - winHeaderFd   書き込み先ファイルディスクリプタ
    //  - pInputPath    生成元パス
    //  - inputSize     pInputPath 配列の要素数
    errno_t WriteAcWinHeader(std::string fileName, nlib_fd winHeaderFd, const std::string* pInputPath);

    // HorizonOS 用の AhoCorasick バイナリを圧縮
    // 成功したら 0 を返す
    //  - fileName      圧縮元ファイル名
    //  - pOutputPath   圧縮後のファイルパス
    //  - pInputPath    圧縮元パス
    errno_t CompressAcBinary(std::string fileName, const std::string* pOutputPath, const std::string* pInputPath);

    // 生成した中間ファイルの削除
    //  - fileName  削除対象ファイル名
    //  - pAcStr    削除する AC バイナリ中間ファイルのパス
    errno_t DeleteIntermediates(std::string fileName, const std::string* pAcStr);

private:
    static const int m_AcTypeSize = 3;      // 1 言語に対して何種類の AhoCorasick を生成するか
    static const int m_LanguageSize = 16;   // NG ワードの対応言語数
    std::string m_RootPath;                 // siglo ツリーのルートパス
    std::string m_NgResourceInputPath;      // 入力元NG ワードリストのあるディレクトリパス
    std::string m_NgResourceOutputPath;     // 出力先ディレクトリパス
    std::string m_CopyrightPath;            // Copyright が記載されたヘッダファイルのパス
    std::string m_WinHeaderPath;            // Windows 用バイナリ配列を記載するヘッダファイルのパス
    int m_Option;                           // オプション
};

