﻿using System.Text;

namespace IFFRefGen.Src
{
    // スキーマのリスト文字列構築
    public class XsdListStringBuilder
    {
        // 文字列の構築
        public static string Build()
        {
            XsdListStringBuilder instance = new XsdListStringBuilder();
            instance.BuildElements();
            instance.BuildComplexTypes();
            instance.BuildSimpleTypes();
            instance.BuildAttributeGroups();
            return instance.ToString();
        }

        // コンストラクタ
        private XsdListStringBuilder()
        {
            this.Builder = new StringBuilder();
            this.TabString = "  ";
        }

        // element
        private void BuildElements()
        {
            this.Builder.Append("Elements:\n");
            this.TabDepth++;
            foreach (XsdElement element in GXsd.Elements)
            {
                AppendTab();
                this.Builder.AppendFormat(
                    "[{0}{1}] {2}\n",
                    (element.IsInitialized ? "i" : " "),
                    (element.IsUsed ? "u" : " "),
                    element.Name);
            }
            this.TabDepth--;
            this.Builder.Append("\n");
        }

        // complexType
        private void BuildComplexTypes()
        {
            this.Builder.Append("ComplexTypes:\n");
            this.TabDepth++;
            foreach (XsdComplexType complexType in GXsd.ComplexTypes)
            {
                AppendTab();
                this.Builder.AppendFormat(
                    "[{0}{1}] {2}\n",
                    (complexType.IsInitialized ? "i" : " "),
                    (complexType.IsUsed ? "u" : " "),
                    complexType.Name);
            }
            this.TabDepth--;
            this.Builder.Append("\n");
        }

        // simpleType
        private void BuildSimpleTypes()
        {
            this.Builder.Append("SimpleTypes:\n");
            this.TabDepth++;
            foreach (XsdSimpleType simpleType in GXsd.SimpleTypes)
            {
                AppendTab();
                this.Builder.AppendFormat(
                    "[{0}{1}] {2}\n",
                    (simpleType.IsInitialized ? "i" : " "),
                    (simpleType.IsUsed ? "u" : " "),
                    simpleType.Name);
            }
            this.TabDepth--;
            this.Builder.Append("\n");
        }

        // attributeGroup
        private void BuildAttributeGroups()
        {
            this.Builder.Append("AttributeGroups:\n");
            this.TabDepth++;
            foreach (XsdAttributeGroup attributeGroup in GXsd.AttributeGroups)
            {
                AppendTab();
                this.Builder.AppendFormat(
                    "[{0}{1}] {2}\n",
                    (attributeGroup.IsInitialized ? "i" : " "),
                    (attributeGroup.IsUsed ? "u" : " "),
                    attributeGroup.Name);
            }
            this.TabDepth--;
            this.Builder.Append("\n");
        }

        // タブの追加
        private void AppendTab()
        {
            for (int i = 0; i < this.TabDepth; i++) { this.Builder.Append(this.TabString); }
        }

        // 文字列化
        public override string ToString()
        {
            return this.Builder.ToString();
        }

        private StringBuilder Builder { get; set; }
        private string TabString { get; set; }
        private int TabDepth { get; set; }
    }
}
