﻿using System;
using System.Xml;

namespace IFFRefGen.Src
{
    // element name type
    public class XsdElement : XsdItem
    {
        // コンストラクタ
        public XsdElement(XmlElement element, string filePath)
            : base(element, filePath) { }

        // 初期化
        public override void Initialize()
        {
            if (this.IsInitialized) { return; }
            base.Initialize();

            this.TypeName = this.Element.GetAttribute("type");
            if (this.TypeName == string.Empty) { Error("type 属性が見つかりません"); }

            // SimpleType の探索
            IXsdType type = GXsd.FindSimpleType(this.TypeName);
            if (type == null)
            {
                // ComplexType の探索
                type = GXsd.FindComplexType(this.TypeName);
            }
            if (type == null) { Error("型が見つかりません " + this.TypeName); }
            this.Type = type;
            this.Type.Initialize();

            //Debug.WriteLine(this);
        }

        // 使用フラグを立てる
        public override void Use()
        {
            if (this.IsUsed) { return; }
            base.Use();
            this.Type.Use();
        }

        // 文字列化
        public override string ToString()
        {
            return string.Format("E  {0} : {1}", this.Name, this.TypeName);
        }

        // 型名
        public string TypeName { get; private set; }
        // 型（simpleType, complexType）
        public IXsdType Type { get; private set; }
    }
}
