﻿using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace IFFRefGen.Src
{
    // attributeGroup
    public class XsdAttributeGroup : XsdItem
    {
        // コンストラクタ
        public XsdAttributeGroup(XmlElement element, string filePath)
            : base(element, filePath)
        {
        }

        // 初期化
        public override void Initialize()
        {
            base.Initialize();

            foreach (XmlNode node in this.Element.ChildNodes)
            {
                if (node.NodeType == XmlNodeType.Comment) { continue; }
                XmlElement element = (XmlElement)node;
                if (element.LocalName == "attribute")
                {
                    XsdAttribute attribute = new XsdAttribute(element, this.FilePath);
                    attribute.Initialize();
                    this.Attributes.Add(attribute);
                }
                else { Error("attribute 以外の子要素があります"); }
            }
        }

        // 使用フラグを立てる
        public override void Use()
        {
            if (this.IsUsed) { return; }
            base.Use();
            foreach (XsdAttribute attribute in this.Attributes)
            {
                attribute.Use();
            }
        }

        // 文字列化
        public override string ToString()
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat("AG {0}", this.Name);
            foreach (XsdAttribute attribute in this.Attributes)
            {
                builder.AppendFormat("\n    {0}", attribute);
            }
            return builder.ToString();
        }

        public List<XsdAttribute> Attributes { get { return _attributes; } }
        private readonly List<XsdAttribute> _attributes = new List<XsdAttribute>();
    }
}
