﻿using System;
using System.Diagnostics;
using System.Xml;

namespace IFFRefGen.Src
{
    // attribute
    public class XsdAttribute : XsdItem
    {
        // コンストラクタ
        public XsdAttribute(XmlElement element, string filePath)
            : base(element, filePath) { }

        // 初期化
        public override void Initialize()
        {
            base.Initialize();

            // アトリビュートの型を参照
            string typeName = this.Element.GetAttribute("type");
            if (typeName == string.Empty) { Error("type 属性が見つかりません"); }

            XsdSimpleType type = GXsd.FindSimpleType(typeName);
            if (type == null)
            {
                // 新しいプリミティブ型を発見
                type = new XsdSimpleType(typeName);
                GXsd.SimpleTypes.Add(type);
            }
            this.Type = type;

            // 属性が必須かどうか
            string use = this.Element.GetAttribute("use");
            switch (use)
            {
                case "required":
                    this.IsRequired = true;
                    break;
                case "prohibited":
                    Error("use 属性の prohibited は非サポートです");
                    break;
                default:
                    Debug.Assert((use == "optional") || (use == string.Empty), "Assertion (toDo)");
                    break;
            }
        }

        // 使用フラグを立てる
        public override void Use()
        {
            if (this.IsUsed) { return; }
            base.Use();
            this.Type.Use();
        }

        // 文字列化
        public override string ToString()
        {
            return string.Format(
                "{0} {1} = {2}",
                (this.IsRequired ? "R" : "O"),
                this.Name,
                this.Type);
        }

        // アトリビュートの型
        public XsdSimpleType Type { get; private set; }
        // アトリビュートが必須かどうか
        public bool IsRequired { get; private set; }
    }
}
