﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using CMDLINE = Common.UtilCmdline;
using LOG = Common.Logger;

namespace DeleteNaviTab
{
    public class CmdlineOption
    {
        public const string UsageString =
@"Usage: DeleteNaviTab [options] doxygen output directory path
    --in-dir-name dirname    set input directory name (default is Build_VsHelp)
    --out-dir-name dirname   set output directory name (default is Out)
    --debug                  enable debug level output
    -h                       show this help
";
        // プロパティ
        private static string __doxygenPath = null;
        private static string __inputDirectoryName = "Build_VsHelp";
        private static string __outputDirectoryName = "Out";
        private static bool __flagPrintDebug = false;
        public static string DoxygenPath
        {
            get { return __doxygenPath; }
        }
        public static string InputDirectoryName
        {
            get { return __inputDirectoryName; }
        }
        public static string OutputDirectoryName
        {
            get { return __outputDirectoryName; }
        }
        public static bool FlagPrintDebug
        {
            get { return __flagPrintDebug; }
        }

        private enum ArgumentParseMode
        {
            PARSE_INPUT_DIRECTORY,
            PARSE_OUTPUT_DIRECTORY,
            PARSE_NONE
        }

        public static bool Parse(string[] args)
        {
            ArgumentParseMode mode = ArgumentParseMode.PARSE_NONE;

            foreach (string arg in args)
            {
                if (mode == ArgumentParseMode.PARSE_INPUT_DIRECTORY)
                {
                    if (!CMDLINE.CheckInputDirArgument(arg))
                    {
                        return false;
                    }
                    __inputDirectoryName = arg;
                    mode = ArgumentParseMode.PARSE_NONE;
                }
                else if (mode == ArgumentParseMode.PARSE_OUTPUT_DIRECTORY)
                {
                    if (!CMDLINE.CheckOutputDirArgument(arg))
                    {
                        return false;
                    }
                    __outputDirectoryName = arg;
                    mode = ArgumentParseMode.PARSE_NONE;
                }
                else if (arg == "--in-dir-name")
                {
                    mode = ArgumentParseMode.PARSE_INPUT_DIRECTORY;
                }
                else if (arg == "--out-dir-name")
                {
                    mode = ArgumentParseMode.PARSE_OUTPUT_DIRECTORY;
                }
                else if (arg == "--degug")
                {
                    __flagPrintDebug = true;
                }
                else if (arg == "-h")
                {
                    Usage();
                    return false;
                }
                else
                {
                    __doxygenPath = Common.UtilFs.AdjustDirectoryPath(arg);
                }
            }
            return true;
        }

        public static void Usage()
        {
            LOG.Log(LOG.Level.LOG_ERROR, CmdlineOption.UsageString);
        }
    }
}
