﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.DotNetLocalizer
{
    public class SnapshotGeneratorInvoker : MarshalByRefObject
    {
        public static void Invoke(string applicationBase, string privateBinPath, string outputDir, string[] excludes, bool langEn)
        {
            AppDomain newDomain = null;
            try
            {
                newDomain = AppDomainUtility.CreateAppDomain(applicationBase, privateBinPath);
                var guiLocalizerApp = AppDomainUtility.CreateInstance<SnapshotGeneratorInvoker>(newDomain);

                // ホスティング・クラスのエントリポイントを呼び出す
                guiLocalizerApp.Execute(applicationBase, outputDir, excludes, privateBinPath, langEn);
            }
            finally
            {
                if (null != newDomain)
                {
                    AppDomain.Unload(newDomain);
                }
            }
        }

        public void Execute(
            string applicationBase,
            string outputXlsxPath,
            string[] excludes,
            string privateBinPath,
            bool langEn)
        {
            var asmFiles = AssemblyUtility.GetAsmFiles(applicationBase, excludes, privateBinPath);

            //--------------------------------------------------------
            // スナップショット作成
            var snapshotGenerator = new SnapshotGenerator(outputXlsxPath);
            foreach (var asmFile in asmFiles)
            {
                snapshotGenerator.Execute(asmFile, !langEn);
            }
        }
    }
}
