﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.IO;
using System.Linq;

namespace Nintendo.DotNetLocalizer
{
    public class AppDomainUtility
    {
        /// <summary>
        /// メインエントリポイント。
        /// </summary>
        // おそらく、スクリーンキャプチャのために、[STAThread] 属性が必要です。
        // [STAThread]
        // public static int Main(string[] args)

        public static AppDomain CreateAppDomain(string applicationBase, string privateBinPath)
        {
            // アプリケーションがあるディレクトリ
            var assemblyPath = Path.GetFullPath(applicationBase);
            Utility.TestError(
                Directory.Exists(assemblyPath),
                "アプリケーションがあるディレクトリ '{0}' が見つかりません。",
                applicationBase);

            return AppDomain.CreateDomain(
                "GuiLocalizerSub",
                null,
                assemblyPath,
                privateBinPath,
                false);
        }

        /// <summary>
        ///  ローカライズ対象のアセンブリをロードするためのAppDomainを作成します。
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="applicationBase"></param>
        /// <param name="privateBinPath"></param>
        /// <param name="newDomain"></param>
        /// <returns></returns>
        public static T CreateInstance<T>(AppDomain appDomain)
        {
            // AppDomain を作成してローカライズ処理を実行。
            var typeT = typeof(T);
            return
                (T)appDomain.CreateInstanceFromAndUnwrap(
                    typeT.Assembly.Location,   // 型が所属するアセンブリのパス
                    typeT.FullName);                                    // 型の名前
        }
    }
}
