﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Foundation.IO;

namespace MakeDictionarySource
{
    internal class MakeDictionaryCppArgs
    {
        private MakeDictionaryCppParams parameters;

        /// <summary>
        /// 解析した結果のパラメータを渡します。
        /// </summary>
        public MakeDictionaryCppParams Params
        {
            get { return parameters; }
        }

        /// <summary>
        /// コマンドラインオプションを解析します
        /// </summary>
        /// <returns>解析の成否</returns>
        public bool ParseArgs(string[] args)
        {
            var settings = new CommandLineParserSettings()
            {
                ApplicationDescription = ".mo ファイルから、アサート・ログメッセージ翻訳用の .h ファイルと、.cpp ファイルを作成します",
                HelpWriter = text =>
                {
                    Console.WriteLine(text);
                },
            };

            if (!new CommandLineParser(settings).ParseArgs(args, out parameters))
            {
                return false;
            }

            return true;
        }

        /// <summary>
        /// 引数解析が失敗したときに呼ばれるメソッドです。
        /// </summary>
        /// <param name="errorInfo">エラーの情報</param>
        private void CommandLineParseError(CommandLineErrorInfo errorInfo)
        {
            Console.Error.WriteLine("CommandLine: {0}", errorInfo.ErrorMessage);
        }
    }
}
