﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

namespace ChangePoEncoding
{
    class Program
    {
        static void Main(string[] args)
        {
            ChangePoEncodingArgs opt = new ChangePoEncodingArgs();

            // コマンドライン引数のパース
            try
            {
                if (!opt.ParseArgs(args))
                {
                    return;
                }
            }
            catch
            {
                Environment.ExitCode = 1;
                return;
            }
            ChangePoEncodingParams param = opt.Params;

            // 入力は BOM あり UTF-8
            Encoding srcEncoding = new UTF8Encoding(true);

            // 出力は、BOM なし UTF-8
            Encoding dstEncoding = new UTF8Encoding(false);

            using (StreamReader reader = new StreamReader(param.InputPath))
            {
                using (FileStream fileStream = new FileStream(param.OutputPath, FileMode.Create))
                using (BinaryWriter writer = new BinaryWriter(fileStream))
                {
                    string src = reader.ReadToEnd();
                    byte[] srcBytes = srcEncoding.GetBytes(src);
                    byte[] dstBytes = Encoding.Convert(srcEncoding, dstEncoding, srcBytes);
                    writer.Write(dstBytes);
                }
            }
        }
    }
}
