﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;

namespace CsScripts
{
    public class BootImageUtility
    {
        public static Dictionary<string, string> MakeHashToNameDictionary(string sourceDirectory)
        {
            var ret = new Dictionary<string, string>();

            foreach (var filename in Directory.EnumerateFiles(sourceDirectory))
            {
                foreach (var line in File.ReadLines(filename))
                {
                    var splitted = line.Split(' ');
                    var name = splitted[0];
                    var hash = splitted[1];

                    ret[hash] = name + "@" + new FileInfo(filename).Name;
                }
            }

            return ret;
        }

        public static string FindMatchedHash(string targetFile, string sourceDirectory)
        {
            var ret = new StringBuilder();

            var hashToName = MakeHashToNameDictionary(sourceDirectory);

            using (var fileStream = File.OpenText(targetFile))
            {
                while (!fileStream.EndOfStream)
                {
                    var line = fileStream.ReadLine().Split(' ');
                    var name = line[0];
                    var hash = line[1];

                    ret.AppendLine(string.Format("{0} {1} ({2})", name, hash, hashToName.ContainsKey(hash) ? hashToName[hash] : "Unknown"));
                }
            }

            return ret.ToString();
        }

    }
}
