﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Reflection;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;

namespace CommitContentChecker
{
    internal static class Utils
    {
        // UTF8でロードを行い、codeContentに格納します
        // ロードが成功した場合 true, 失敗した場合 false を返します。
        internal static bool LoadFile(string codeFilename, bool emitBOM, out string codeContent)
        {
            codeContent = null;

            try
            {
                Encoding encoding = new UTF8Encoding(emitBOM, true);   // UTF8エンコーディング

                using (StreamReader sr = new StreamReader(codeFilename, encoding, false))
                {
                    codeContent = sr.ReadToEnd();
                }
            }
            catch (System.Exception exception)
            {
                Console.Error.WriteLine(codeFilename + ": Error: Failed to read committed file");
                Console.Error.WriteLine(exception);
                return false;
            }
            return true;
        }

        // UTF8でデータの保存を行います。
        // 保存が成功した場合 true, 失敗した場合 false を返します。
        internal static bool SaveFile(string codeContent, string codeFilename, bool emitsBOM)
        {
            Encoding encoding = new UTF8Encoding(emitsBOM, true);   // UTF8エンコーディング

            try
            {
                using (StreamWriter sw = new StreamWriter(codeFilename, false, encoding))
                {
                    sw.Write(codeContent);
                }
            }
            catch (System.Exception exception)
            {
                Console.Error.WriteLine(codeFilename + ": Error: Failed to write file");
                Console.Error.WriteLine(exception);
                return false;
            }
            return true;
        }
    }
}
