﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VsSolutionLibrary
{
    /// <summary>
    /// VsProjectType と Guid の対応を管理するクラス
    /// </summary>
    internal class VsProjectTypeUtility
    {
        private static Dictionary<VsProjectType, Guid> m_Guids;

        static VsProjectTypeUtility()
        {
            m_Guids = new Dictionary<VsProjectType, Guid>();
            m_Guids[VsProjectType.VisualBasic] = new Guid("{F184B08F-C81C-45F6-A57F-5ABD9991F28F}");
            m_Guids[VsProjectType.VisualC] = new Guid("{8BC9CEB8-8B4A-11D0-8D11-00A0C91BC942}");
            m_Guids[VsProjectType.CSharp] = new Guid("{FAE04EC0-301F-11D3-BF4B-00C04F79EFBC}");
            m_Guids[VsProjectType.FSharp] = new Guid("{F2A71F9B-5D33-465A-A702-920D77279786}");
            m_Guids[VsProjectType.VisualJSharp] = new Guid("{E6FDF86B-F3D1-11D4-8576-0002A516ECE8}");
            m_Guids[VsProjectType.Web] = new Guid("{E24C65DC-7377-472b-9ABA-BC803B73C61A}");
            m_Guids[VsProjectType.SolutionFolder] = new Guid("{2150E333-8FDC-42A3-9474-1A3956D46DE8}");
        }

        public static VsProjectType GetProjectTypeFromGuid(Guid guid)
        {
            foreach (VsProjectType projectType in Enum.GetValues(typeof(VsProjectType)))
            {
                if (m_Guids[projectType] == guid)
                {
                    return projectType;
                }
            }

            throw new ArgumentException("ソリューションに不正な ProjectType が含まれています。");
        }

        public static Guid GetGuidFromProjectType(VsProjectType projectType)
        {
            return m_Guids[projectType];
        }
    }
}
