﻿<#
    Copyright (C)Nintendo. All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.
 
    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS

    .DESCRIPTION

    .INPUTS
    なし。

    .OUTPUTS
    なし。
#>
[CmdletBinding()]
Param(
<#
    [parameter(Mandatory = $true)]
    [string[]] $Path
#>
)

# このスクリプトが置かれているディレクトリ
$scriptDir = Split-Path $MyInvocation.MyCommand.Path -Parent

# エラー出力に書き出されたらストップする。
$ErrorActionPreference = "Stop"

# ビルド
& "$Env:SystemRoot/Microsoft.NET/Framework64/v4.0.30319/MSBuild" `
    $scriptDir/../../Sources/Tools/PlatformCodeFilter/PlatformCodeFilter.sln `
    /m /t:Build "/p:Configuration=Release"

# ビルドしたモジュールをインポート
Import-Module $scriptDir/../../Outputs/AnyCPU/Tools/PlatformCodeFilter/PlatformCodeFilter/Release/PlatformCodeFilter.psd1

# ソースコードから 特定のプラットフォームを除外する。

$platformDefine = @{
    # nvn
    ANDROID = 0x0808
    __ANDROID__ = 0x0808
    NV_WINSYS_CAPS_API_BACKEND_ANDROID = 0x0808
    TARGET_HOST_ANDROID = 0x0808

    __linux__ = 0x0808
}

$sigloRoot = Join-Path $scriptDir ../../..

"Externals\odin2\nvn-samples\samples\common",
"Externals\odin2\nvn-samples\samples\nvn_basic",
"Externals\odin2\nvn-samples\samples\simple-triangle",
"Externals\odin2\nvn-samples\samples\textured-triangle" |
ForEach-Object { Join-Path $sigloRoot $_ } |
Get-ChildItem -Recurse -Include *.cpp,*.c,*.h |
Convert-PlatformCode -Macro $platformDefine -Enable 0xE7E7
