﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Stop TargetManager

    .DESCRIPTION
        Terminate Target Manager.
#>

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}\Modules\Path"
Import-Module "${scriptDirectoryPath}\Modules\Utility"

# TargetManager がタスクトレイに入っているとうまく終了できないので、一旦ウィンドウを表示させる
$TargetManagerPath = "$(Get-NintendoSdkRootPath)\Externals\Oasis\bin\NintendoTargetManager.exe"
$TargetManagerProcess = Get-Process | where {$_.Name.Equals("NintendoTargetManager")}
if ($TargetManagerProcess -ne $null)
{
    Start-Process $TargetManagerPath
    Start-Sleep -s 1
}

$ret = Close-ProgramGracefullyByName -Name "NintendoTargetManager"
if( !$ret )
{
    Write-Host "Failed to terminate NintendoTargetManager. So, kill NintendoTargetManager process."
    try
    {
        Stop-ProcessByName -Name NintendoTargetManager
    }
    catch [Exception]
    {
        # Do nothing because this exception may be caused by process not found
    }
}
