﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Start logging of Uart.

    .DESCRIPTION
        Start logging of Uart.
#>

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}\Modules\Path"

$ReadSerialPath = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/ReadSerial.exe"

$Timestamp = Get-Date | % { $_.ToString("yyyyMMddhhmmss")}
$UartLogDirectory = "$(Get-NintendoSdkRootPath)/Integrate/Outputs/Uart/${Timestamp}"
$UartLogPath = "$UartLogDirectory/Uart_log.txt"


if ( !(Test-Path $UartLogDirectory -Type Container) ) {
    New-Item $UartLogDirectory -itemType Directory
}

$ProcessInfo = Start-Process $ReadSerialPath -RedirectStandardOutput $UartLogPath -NoNewWindow -PassThru

return $ProcessInfo
