﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
    FairlyLinguist の出力のうちエラーに関するものを抽出し、エラー出力に吐き出します。

    .DESCRIPTION
    FairlyLinguist の出力のうちエラーに関するものを抽出し、エラー出力に吐き出します。
    また、エラーとなっているページのConfluence上のURLを追加します。

    .INPUTS
    なし。

    .OUTPUTS
    なし。
#>

[CmdletBinding()]
Param(
    # FairlyLinguist が生成する ConvertLog_???.log へのパスを指定します。
    [parameter()]
    $ConvertLog = 'Documents\Package\logs\ConvertLog_*.log',

    # FairlyLinguist が生成する PageLists.csv へのパスを指定します。
    [parameter()]
    $PageListCsv = 'Documents\Package\logs\PageLists.csv',

    # Confluence上のページのURL部分を指定します。
    [parameter()]
    $PageUrl = 'https://spdlybra.nintendo.co.jp/confluence/pages/viewpage.action?pageId='
)

# PageLists.csv を読み込み、ページタイトルからIDを導くためのハッシュテーブルを作成します。
$pageDic = @{}
Get-Content $PageListCsv -Encoding UTF8 |
Select-Object -Skip 1 |
ForEach-Object {
    $id,$level, $title = $_ -split ",",3
    $pageDic[$title -replace '^"(.*)"$','$1'] = $id -replace '^"(.*)"$','$1'
}

# エラーの行を抽出し、エラー出力に書き込みます。
Get-Content $ConvertLog -Encoding UTF8 |
ForEach-Object {
    $line = $_
    if ($line -match '^\d{4}/\d{2}/\d{2} \d{2}:\d{2}:\d{2} \((M|W|E)\)') {
        switch -Regex ($Matches[1]) {
#            'M' { $host.UI.WriteLine($line) }
#            'W' { $host.UI.WriteWarningLine($line) }
            'E' {
                # ページタイトルからIDを見つけることが出来たら、そのURLを付加する。
                if ($line -match '（「([^」]*)」内）$') {
                    $pageId = $pageDic[$Matches[1]]
                    if ($pageId) {
                        $line = "{0} - {1}{2}" -f $line,$PageUrl,$pageId
                    }
                }
                $host.UI.WriteErrorLine($line)
            }
        }
    }
}
