﻿# powershell -File replacer.ps1 -TemplateFile NvnDriver.zarf.yml.template -InfoFile info.json

Param
(
    [Parameter(Mandatory=$true)]
    [string] $TemplateFile,

    [Parameter(Mandatory=$true)]
    [string] $MsiDir,

    [Parameter(Mandatory=$true)]
    [string] $OutputZarfFile,

    [Parameter(Mandatory=$true)]
    [string] $OutputMsiDir
)

$scriptDir = Split-Path $MyInvocation.MyCommand.Path -Parent

Import-Module $scriptDir/../Modules/Error
Import-Module $scriptDir/../Modules/Path

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

$ErrorActionPreference = "Stop"

$sdkRoot = Get-NintendoSdkRootPath

# パッケージする TargetManager の特定
$vsi = Get-ChildItem $MsiDir\TargetManager.*.msi

if (Test-Path $OutputMsiDir) {
    Remove-Item $OutputMsiDir -Recurse
}
$dstDir = mkdir $OutputMsiDir

# vsi のコピー
Copy-Item $vsi $dstDir.FullName

# バージョン文字列の作成
# XX.0.0.0.0.msi
# XX.0.0.0.0_hotfix0.msi
$versions = [regex]::Matches($vsi.Name, "(\d+)\.(\d+)\.(\d+)\.([^\.]+)\.")[0]
$versionString = "{0}.{1}.{2}+REV{3}" -F $versions.Groups[1], $versions.Groups[2], $versions.Groups[3], $versions.Groups[4].toString().replace('_', '')

# テンプレートの置き換え
$template = Get-Content $TemplateFile | ForEach-Object { $_.Replace('${VERSION}', $versionString).Replace('${INSTALLER}', $vsi.Name) }
$template | Set-Content $OutputZarfFile -Encoding UTF8
