﻿#
#    COMMAND 
#
param
(
    [string]$InputDir = "",
    [string]$RuleFile = "",
    [switch]$Detail = $false
)

#---- ルールの読み込み
[Xml]$Rules = Get-Content -Encoding UTF8 $RuleFile

#---- ルール個数
$RuleNum = $Rules.NgWord.Rule.Length

#================================================================
function Check-Line( $checkLine, $ruleIndex )
{
    #---- 除外ルール
    $exceptionRule = ([array]$script:RuleSet.Rule)[$ruleIndex].Exception
    if ( $exceptionRule -eq $null -or $exceptionRule -eq "" )
    {
        # 除外ルールが無い場合は無条件に合致
    }
    else
    {
        $w0 = $checkLine
        $r0 = ""
        while($true)
        {
            if ( $w0 -cmatch ( "(.*?)({0})(.*)" -f ([array]$script:RuleSet.Rule)[$ruleIndex].Exception ) )
            {
                $r0 += $matches[1] + "#"
                $w0 = $matches[3]
            }
            else
            {
                $r0 += $w0
                break
            }
        }

        #---- 除外ルールを除き改めてチェック
        if ( -not ( $r0 -cmatch ([array]$script:RuleSet.Rule)[$ruleIndex].Match  ) )
        {
            return
        }
    }

    #---- 検出を表示
    Write-Host ("{0} ({1})  {2} の検出  : {3}" -f $script:FileName, $script:LineNum, ([array]$script:RuleSet.Rule)[$ruleIndex].Title, $checkLine)
}

#================================================================
$RuleSetNum = ([array]$Rules.NgWord.RuleSet).Length

Get-ChildItem -Recurse $InputDir | ?{ $_.GetType().Name -eq "FileInfo" } | `
%{
    $FileName = ([string]$_.FullName)

    #---- 各ルールセットに照らし合わせる
    $RuleSetIndex = 0
    for( $RuleSetIndex=0; $RuleSetIndex -lt $RuleSetNum; $RuleSetIndex++ )
    {
        $RuleSet = ([array]$Rules.NgWord.RuleSet)[$RuleSetIndex]

        #---- 拡張子が条件に合っているものをチェック
        if ( $_ -match (".*.{0}$" -f $RuleSet.Extension ) )
        {
            $RuleNum = ([array]$RuleSet.Rule).Length
            $LineNum = 0

            #---- 各行のチェック
            Get-Content -LiteralPath $FileName | `
            %{
                 $LineNum ++
                 for( $i=0; $i -lt $RuleNum; $i++ )
                 {
                    if ( $_ -cmatch ([array]$RuleSet.Rule)[$i].Match )
                    {
                        #---- 確認
                        Check-Line $_ $i
                    }
                 }
             }
        }
    }
}

Write-Host "*** Done."
