<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Get BootImageHash from Integrate/Outputs/DumpedBootImages
#>
[CmdletBinding()]
Param
(
    [string]
    $DumpedName
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"
Import-Module "${scriptDirectoryPath}/../../Modules/Runner"
Import-Module "${scriptDirectoryPath}/../../Modules/UsbTarget"

$SourceDirectory = "$(Get-NintendoSdkRootPath)/Integrate/Outputs/DumpedBootImages/$DumpedName"

$OutputFile = "$(Get-NintendoSdkRootPath)/Integrate/Outputs/DumpedBootImages/$DumpedName/HashList.txt"
$SourceHashListDirectory = "$(Get-NintendoSdkRootPath)/Integrate/Sources/BootImageHash"

$Bct00 = "$SourceDirectory/Bct00-NormalMain.img"
$Bct01 = "$SourceDirectory/Bct01-SafeMain.img"
$Bct02 = "$SourceDirectory/Bct02-NormalBackup.img"
$Bct03 = "$SourceDirectory/Bct03-SafeBackup.img"
$BlTruncated00 = "$SourceDirectory/BlTruncated00-NormalMain.img"
$BlTruncated01 = "$SourceDirectory/BlTruncated01-NormalSub.img"
$BlTruncated02 = "$SourceDirectory/BlTruncated02-SafeMain.img"
$BlTruncated03 = "$SourceDirectory/BlTruncated03-SafeSub.img"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

if([String]::IsNullOrEmpty($DumpedName))
{
    ls "$(Get-NintendoSdkRootPath)/Integrate/Outputs/DumpedBootImages"
    throw "DumpedName is not set."
}

# 既存ファイルの削除
if (Test-Path $OutputFile) {
    rm $OutputFile
}

# ダンプされたファイルのハッシュ値の計算
Get-NameAndHash $Bct00 > $OutputFile 
Get-NameAndHash $Bct01 >> $OutputFile
Get-NameAndHash $Bct02 >> $OutputFile
Get-NameAndHash $Bct03 >> $OutputFile
Get-NameAndHash $BlTruncated00 >> $OutputFile
Get-NameAndHash $BlTruncated01 >> $OutputFile
Get-NameAndHash $BlTruncated02 >> $OutputFile
Get-NameAndHash $BlTruncated03 >> $OutputFile

Import-CsScripts "BootImageUtility/BootImageUtility"

Write-Output $([CsScripts.BootImageUtility]::FindMatchedHash($OutputFile, $SourceHashListDirectory)) > $OutputFile

Get-Content $OutputFile
Write-Host "output to $OutputFile"
