﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Sign package2

    .DESCRIPTION
        Sign p2.img
#>

#
#    COMMAND [-AuthenticationFile <file>|-AuthenticationPrompt] [-InFile <file>] [-OutFile <file>]
#
#       -AuthenticationFile <file>  認証情報が書かれている xml ファイルのパス。
#       -AuthenticationPrompt       認証情報をキーボードから受け取る。AuthenticationFile が指定されていればそちらを優先
#       -InFile <file>              署名対象となるファイルのパス。
#       -OutFile <file>             署名して書き出されるファイルのパス。
#

param
(
    [string]$AuthenticationFile,
    [switch]$AuthenticationPrompt = $false,
    [parameter(Mandatory=$True)] [string]$InFile,
    [parameter(Mandatory=$True)] [string]$OutFile
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${ScriptDirectoryPath}\..\Modules\Error"
Import-Module "${ScriptDirectoryPath}\..\Modules\Sign"

# 例外ハンドラ
trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

# Authentication File が指定されている
if ( "" -ne $AuthenticationFile )
{
    [Xml]$Config = Get-Content $AuthenticationFile
    $Username = $Config.Configuration.User
    $Password = $Config.Configuration.Password
    $Credential = New-Object System.Net.NetworkCredential($Username, $Password)
}
ElseIf ( $AuthenticationPrompt )
{
    $Credential = Get-Credential -Message "Credencial for the p2 signings erver"
}

# 署名処理の呼び出し
SignFile "$InFile" "$OutFile" "https://devrepo01.ncl.nintendo.co.jp:10443/sign" $Credential
