﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        修理システムを更新します

    .DESCRIPTION
        修理システムを更新します
#>

[CmdletBinding()]
Param
(
    [string]
    $KeyType = 'K5',

    [string]
    $ConnectionType = 'Manu',

    [string]
    $SignedType = 'Unsigned',

    [string]
    $BootType = 'ManuBoot',

    [string]
    $StorageSize = '32G',

    [string]
    $BuildType = 'Develop',

    [string]
    $Platform = 'NX-NXFP2-a64',

    [string]
    $ConfigName = "TestWsIssuerServerConfig",

    [string]
    $DevicePath = "",

    [string]
    $DoProcessClean = "true"
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}/../../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../../Modules/Utility"

$SystemUpdater = "$($scriptDirectoryPath)/SystemUpdater.ps1"
Test-EnsureExistPath $SystemUpdater

$DevicePathOption = ""
if(![System.String]::IsNullOrEmpty($DevicePath))
{
    $DevicePathOption = "-DevicePath $DevicePath"
}

Invoke-CriticalCommand "& `"$SystemUpdater`" ``
    -KeyType $KeyType ``
    -ConnectionType $ConnectionType ``
    -SignedType $SignedType ``
    -BootType $BootType ``
    -StorageSize $StorageSize ``
    -BuildType $BuildType ``
    -Platform $Platform ``
    -ConfigName $ConfigName ``
    $DevicePathOption ``
    -DoProcessClean $DoProcessClean "
