﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Write RecoverySystem by QSPI boot

    .DESCRIPTION
        Write RecoverySystem by QSPI boot.
#>
[CmdletBinding()]
Param
(
    # The host IP address pattern as RegularExpression
    [string]
    $AddressPattern,
    
    [string]
    $BuildType = 'Develop',

    [string]
    $Platform = 'NX-NXFP2-a64',
    
    [string]
    $RecoveryWriter
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/HostBridge"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"

Test-ParameterIsNotNullOrEmpty -Name "AddressPattern" -Value $AddressPattern

$StartTarget  = "$(Get-NintendoSdkRootPath)/Integrate/Scripts/NX/Recovery/Start-Target.ps1"
$InvokeQspiBoot = "$(Get-NintendoSdkRootPath)/Integrate/Scripts/NX/Recovery/Invoke-QspiMode.ps1"
$RestartTarget  = "$(Get-NintendoSdkRootPath)/Integrate/Scripts/NX/Recovery/Restart-Target.ps1"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

if([String]::IsNullOrEmpty($RecoveryWriter))
{
    $QspiBootImage = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/SystemImages/QspiBootImages/RecoveryWriter/$BuildType/RecoveryWriter.qspi.img"
}
else
{
    $QspiBootImage = $RecoveryWriter
}

Test-EnsureExistPath $QspiBootImage
Invoke-CriticalCommand "& `"$StartTarget`" -AddressPattern `"$AddressPattern`""
Invoke-CriticalCommand "& `"$InvokeQspiBoot`" -AddressPattern `"$AddressPattern`" -QspiBootImage `"$QspiBootImage`""
Wait-Seconds 15
Invoke-CriticalCommand "& `"$RestartTarget`" -AddressPattern `"$AddressPattern`""
Wait-Seconds 5
