<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Replace binaries to prod for Qspi Image

    .DESCRIPTION
        Replace binaries to prod for Qspi Image
#>
[CmdletBinding()]
Param
(
    [string]
    $KeyType = 'M2',

    [string]
    $ConnectionType = 'Manu',

    [string]
    $SignedType = 'Signed',

    [string]
    $BootType = 'ManuBoot',

    [string]
    $StorageSize = '32G',

    [string]
    $DeveloperType = 'ManufacturingTest',

    [string]
    $BuildType = 'Release',

    [string]
    $Platform = 'NX-NXFP2-a64',

    [string]
    $ConvertYamlFile = "",

    [switch]
    $RenameToProd
)

$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"

$ProdKeyType = "M4"
$MakeFirmwareArchive  = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/MakeFirmwareArchive/MakeFirmwareArchive.exe"
$ImageType = "RecoveryWriter-$KeyType-$ConnectionType-$SignedType"
$ProdImageType = "RecoveryWriter-$ProdKeyType-$ConnectionType-$SignedType"
$NfaPath = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/FirmwareArchives/$ImageType/$BuildType/$ImageType.nfa"
$ReplacedProdNfaPath = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/FirmwareArchives/$ProdImageType/$BuildType/$ProdImageType.nfa"
$ymlPath = "$ConvertYamlFile-tmp.yml"

if("" -eq $ConvertYamlFile)
{
    $ConvertYamlFile = "$(Get-NintendoSdkRootPath)/Integrate/Scripts/NX/Manufacturing/Manufacture-ConvertToQspiBootImage-M4.yml"
}

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

Get-Content $ConvertYamlFile | foreach {
    $ConvertRule += $_ -creplace "{SigloRoot}", "$(Get-NintendoSdkRootPath)"
    $ConvertRule += "`r`n"
}

$ConvertRule | Out-File $ymlPath

$ReplacedProdNfaDirectoryPath = [System.IO.Path]::GetDirectoryName($ReplacedProdNfaPath)
if (!(Test-Path $ReplacedProdNfaDirectoryPath)) {
    New-Item $ReplacedProdNfaDirectoryPath -itemType Directory | Out-Null
}

Invoke-Expression "& `"$MakeFirmwareArchive`" executelist -i `"$NfaPath`" -o `"$ReplacedProdNfaPath`" --list `"$ymlPath`""

Remove-Item $ymlPath
if($RenameToProd)
{
    Move-Item -Force $ReplacedProdNfaPath ($ReplacedProdNfaPath -replace ".nfa", ".prod.nfa")
}
