<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Create the package of prod mp.

    .DESCRIPTION
        Create the package of prod mp.
#>
[CmdletBinding()]
Param
(
    [string]
    $KeyType = "M4"
)

$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"

$PackageCreator = "$(Get-NintendoSdkRootPath)/Integrate/Outputs/AnyCPU/Tools/PackageCreator/PackageCreator/Release/PackageCreator.exe"
$SourceFile = "$(Get-NintendoSdkRootPath)/Integrate/Packages/PackageDefinitions/NX/Manufacturing/ManufacturingProd-$KeyType.package.yml"
$OutputDir = "$(Get-NintendoSdkRootPath)/Integrate/Outputs/Packages/NX/Manufacturing"
$OutputName = "ManufacturingProd-$($KeyType)Package.zip"
$RevisionFile = "$(Get-NintendoSdkRootPath)/Integrate/Outputs/Packages/Info/Revision.txt"
$OutputRevisionFile = "Revisions/ManufacturingProd-$($KeyType)Package_Revision.txt"

Invoke-Expression "& `"$PackageCreator`" --root `"$(Get-NintendoSdkRootPath)`" --source-file $SourceFile --output-dir $OutputDir --output-name $OutputName --select-file-tree fs --check-file-existence error --revision-file $RevisionFile --output-revision-file $OutputRevisionFile "
