<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Create PseudoProdKey Qspi Image

    .DESCRIPTION
        Create PseudoProdKey Qspi Image
#>
[CmdletBinding()]
Param
(
    [string]
    $KeyType = 'K6',

    [string]
    $ConnectionType = 'Manu',

    [string]
    $SignedType = 'Signed',

    [string]
    $BootType = 'ManuBoot',

    [string]
    $StorageSize = '32G',

    [string]
    $DeveloperType = 'ManufacturingTest',

    [string]
    $BuildType = 'Release',

    [string]
    $Platform = 'NX-NXFP2-a64',

    [string]
    $Suffix = '',

    [switch]
    $Encrypt = $false
)

$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)

if($Suffix.Length -ne 0)
{
    Write-Host "  Suffix:         $Suffix"
}

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"

$SystemPartitionName       = "Manufacture1stInitializeSystemPartition"
$RecoveryWriterName = "RecoveryWriter-$KeyType-$ConnectionType-$SignedType"
$MakeSignedSystemPartition = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/MakeSignedSystemPartition.exe"
$InternalSignKeyFile       = "$(Get-NintendoSdkRootPath)/Integrate/Sources/Configs/SignedFatImage/Internal.yaml"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

if ($KeyType -eq "K6") {
    $SystemPartitionNamePath   = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/SystemImages/SystemPartition/$SystemPartitionName/$BuildType/$SystemPartitionName$Suffix.prod.fatimg"
    $QspiBootArchivePath       = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/FirmwareArchives/$RecoveryWriterName/$BuildType/$RecoveryWriterName$Suffix.prod.nfa"
    $EnableEncryptionArg = ""
}
else {
    $SystemPartitionNamePath   = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/SystemImages/SystemPartition/$SystemPartitionName/$BuildType/$SystemPartitionName$Suffix.fatimg"
    $QspiBootArchivePath       = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/FirmwareArchives/$RecoveryWriterName/$BuildType/$RecoveryWriterName$Suffix.nfa"
    $EnableEncryptionArg = "--enable-develop-image"
}

Test-EnsureExistPath $QspiBootArchivePath
Test-EnsureExistPath $MakeSignedSystemPartition
Test-EnsureExistPath $InternalSignKeyFile

$OutputDirectoryPath = [System.IO.Path]::GetDirectoryName($SystemPartitionNamePath)
if (!(Test-Path $OutputDirectoryPath)) {
    New-Item $OutputDirectoryPath -itemType Directory | Out-Null
}

if ($Encrypt)
{
    $EncryptOption = "--encrypt"
}

Invoke-Expression "& `"$MakeSignedSystemPartition`" --size 11 --free-space 2900KiB -i `"$QspiBootArchivePath`" -o `"$SystemPartitionNamePath`" --key `"$InternalSignKeyFile`" $EnableEncryptionArg $EncryptOption"
