<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Create Prod InitialImage nfa

    .DESCRIPTION
        Create Prod InitialImage nfa
#>
[CmdletBinding()]
Param
(
    [string]
    $KeyType = 'K5',
    
    [string]
    $ConnectionType = 'Manu',
    
    [string]
    $SignedType = 'Signed',
    
    [string]
    $BootType = 'ManuBoot',
    
    [string]
    $StorageSize = '32G',
    
    [string]
    $DeveloperType = 'ManufacturingTest',
    
    [string]
    $BuildType = 'Release',
    
    [string]
    $Platform = 'NX-NXFP2-a64'
)

$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"

$ProdKeyName = "K6"
$InitialImageName = "NX-$ProdKeyName-$ConnectionType-$SignedType-$BootType-$StorageSize-$DeveloperType"
$InitialArchiveName  = "$InitialImageName"
$InitialArchivePath  = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/FirmwareArchives/$InitialArchiveName/$BuildType/$InitialArchiveName.nfa"
$ProdInitialArchivePath = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/FirmwareArchives/$InitialArchiveName/$BuildType/$InitialArchiveName.prod.nfa"
$ChangeFirmwareArchiveKey = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/ChangeFirmwareArchiveKey.exe"
$ChangeFirmwareArchiveResult = [System.IO.Path]::GetDirectoryName($ProdInitialArchivePath)
$KeyConfigPath        = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/AuthoringTool/AuthoringTool.repository.keyconfig.xml";

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

Test-EnsureExistPath $InitialArchivePath
Test-EnsureExistPath $ChangeFirmwareArchiveKey
Test-EnsureExistPath $KeyConfigPath

Invoke-Expression "& `"$ChangeFirmwareArchiveKey`" --verbose -i `"$InitialArchivePath`" -o `"$ProdInitialArchivePath`" --keyconfig `"$KeyConfigPath`" --result `"$ChangeFirmwareArchiveResult`""