<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Break BCT by manu connection.

    .DESCRIPTION
        Break BCT by manu connection.
#>
[CmdletBinding()]
Param
(
    [string]
    $BuildType = 'Release',
    
    [string]
    $Platform = 'NX-NXFP2-a64',

    [string]
    $KeyType = "K6",

    [string]
    $ConfigName = "LocalWsIssuerServerConfig",

    [string]
    $DevicePath = "",

    [bool]
    $DoProcessClean = $true
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

# Names
$ImageName                = "BreakBct"

# File names
$RunSystemInitializerManu = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/RunSystemInitializerManu.exe" 
$ImagePath                = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/NX-NXFP2-a64/InitialImages/$ImageName/$BuildType/$ImageName.$KeyType.initimgm"
$TemporaryDirectory       = "$(Get-NintendoSdkRootPath)/Integrate/Outputs"
$ConfigPath               = "$(Get-NintendoSdkRootPath)/Integrate/Sources/Configs/RequestToWsIssuerConfig/$ConfigName.yaml" 

# Test existing files
Test-EnsureExistPath $RunSystemInitializerManu
Test-EnsureExistPath $ImagePath
Test-EnsureExistPath $ConfigPath

if($DoProcessClean)
{
    Stop-ProcessesForSystemInitialize
}
else
{
    Write-Host "Skip Process Cleaning."
}

if (!(Test-Path $TemporaryDirectory)) {
    New-Item $TemporaryDirectory -itemType Directory | Out-Null
}

$DevicePathOption = ""
if($DevicePath)
{
    $DevicePathOption = "--usb_device_path $DevicePath"
}

# Initialize
Invoke-Expression "& `"$RunSystemInitializerManu`" $DevicePathOption --verbose --image $ImagePath --initializer 0100000000002103 --tmpdir $TemporaryDirectory --config $ConfigPath --timeout 180"
