<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Initialize final dp by system updater.

    .DESCRIPTION
        Initialize final dp by system updater.
#>
[CmdletBinding()]
Param
(
    [string]
    $BuildType = 'Develop',
    
    [string]
    $Platform = 'NX-NXFP2-a64',
    
    [string]
    $BootConfig = 'Skip', # Skip, <BootConfigFile>

    [string]
    $AddressPattern = '.*',
    
    [string]
    $RecoveryConnectionType  = 'Usb', # Hb, Usb

    [switch]
    $SkipStopTargetManager = $false,

    [switch]
    $SkipStopProcessesForCi = $false
)

$KeyType = "K5"
$ConnectionType = "NoConnect"
$BootType = "ProdBoot"
$SignedType = "Unsigned"
$StorageSize = "32G"
$DeveloperType = "ProdModeAutoTest"

$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)

$InitializeEdevRaw    = "$($scriptDirectoryPath)/Initialize-Edev-Full-Raw.ps1"
$InitializeSdevRaw    = "$($scriptDirectoryPath)/Initialize-Sdev-Full-Raw.ps1"

if($RecoveryConnectionType -eq 'Hb')
{
    Invoke-Expression "& `"$InitializeSdevRaw`" -BootConfig `"$BootConfig`" -AddressPattern $AddressPattern -BuildType $BuildType -Platform $Platform -KeyType $KeyType -ConnectionType $ConnectionType -RecoveryConnectionType $RecoveryConnectionType -BootType $BootType -SignedType $SignedType -StorageSize $StorageSize -DeveloperType $DeveloperType -SkipHelloWorld  -SkipStopTargetManager:`$$SkipStopTargetManager -SkipStopProcessesForCi:`$$SkipStopProcessesForCi"
}
else
{
    Invoke-Expression "& `"$InitializeEdevRaw`" -BootConfig `"$BootConfig`" -BuildType $BuildType -Platform $Platform -KeyType $KeyType -ConnectionType $ConnectionType -BootType $BootType -SignedType $SignedType -StorageSize $StorageSize -DeveloperType $DeveloperType -SkipStopTargetManager:`$$SkipStopTargetManager -SkipStopProcessesForCi:`$$SkipStopProcessesForCi"
}
