﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        NX Aging Module

    .DESCRIPTION
        Modules for start_aging_ssd CI job
#>

$moduleFilePath = $MyInvocation.MyCommand.Path
$modulePath     = [System.IO.Path]::GetDirectoryName($moduleFilePath)
$moduleRootPath = [System.IO.Path]::GetDirectoryName($modulePath)

Import-Module "${moduleRootPath}/Path"

function Get-InitialImageName(
    [Boolean]
    $useProdBoot,
    
    [Boolean]
    $useSdLog,

    [Boolean]
    $useDummyStarter,
    
    [string]
    $keyType,

    [string]
    $signedType
)
{
    #
    # パラメータに応じて初期化スクリプトのパスを生成
    #
    $bootType = ""
    $developerType = ""
    $storageSize = ""
    $connectionType = ""

    if ($UseProdBoot)
    {
        $bootType += "ProdBoot"
        $developerType += "ProdMode"
        $storageSize += "32G"
        $connectionType += "NoConnect"
    }
    else
    {
        $bootType += "Nand"
        $developerType += "Internal"
        $storageSize += "64G"
        $connectionType += "Hb"
    }
    if ($UseSdLog)
    {
        $developerType += "SdLog"
    }

    if ($UseDummyStarter)
    {
        $developerType += "AutoTest"
    }

    return "NX-$keyType-$connectionType-$signedType-$bootType-$storageSize-$developerType"
}
Export-ModuleMember -Function Get-InitialImageName

function Get-ResultDirectoryPath()
{
    return "$(Get-NintendoSdkRootPath)\Integrate\Outputs\NxAgingTools"
}

function Clear-ResultDirectory()
{
    $path = Get-ResultDirectoryPath

    if (Test-Path "${path}")
    {
        Remove-Item -Recurse "${path}"
    }
    New-Item -ItemType Directory "${path}"
}
Export-ModuleMember -Function Clear-ResultDirectory

function Write-InitializeLog(
    [string]
    $target,

    [string]
    $log
)
{
    $path = "$(Get-ResultDirectoryPath)\Initialize_${target}.log"
    echo $log > $path
}
Export-ModuleMember -Function Write-InitializeLog

function Read-InitializeLog(
    [string]
    $target
)
{
    $path = "$(Get-ResultDirectoryPath)\Initialize_${target}.log"
    return Get-Content $path
}
Export-ModuleMember -Function Read-InitializeLog

# 与えられたターゲットのうち、初期化ログが $filter で始まるターゲットを返す
function Filter-TargetByInitializeLog(
    [string[]]
    $targets,

    [string]
    $filter
)
{
    $ret = @()

    foreach ($target in $targets)
    {
        $path = "$(Get-ResultDirectoryPath)\Initialize_${target}.log"
        $log = Get-Content $path
        if ($log.StartsWith($filter))
        {
            $ret += $target
        }
    }

    return $ret
}
Export-ModuleMember -Function Filter-TargetByInitializeLog
